/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import java.time.Duration;
import java.util.Optional;

public class DecrementOptions
extends CommonDurabilityOptions<DecrementOptions> {
    private long delta = 1L;
    private Optional<Long> initial = Optional.empty();
    private Duration expiry = Duration.ZERO;
    private long cas = 0L;

    public static DecrementOptions decrementOptions() {
        return new DecrementOptions();
    }

    private DecrementOptions() {
    }

    public DecrementOptions delta(long delta) {
        if (delta < 0L) {
            throw InvalidArgumentException.fromMessage((String)"The delta cannot be less than 0");
        }
        this.delta = delta;
        return this;
    }

    public DecrementOptions initial(long initial) {
        this.initial = Optional.of(initial);
        return this;
    }

    public DecrementOptions expiry(Duration expiry) {
        this.expiry = expiry;
        return this;
    }

    public DecrementOptions cas(long cas) {
        this.cas = cas;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonDurabilityOptions.BuiltCommonDurabilityOptions {
        Built() {
            super(DecrementOptions.this);
        }

        public Duration expiry() {
            return DecrementOptions.this.expiry;
        }

        public Optional<Long> initial() {
            return DecrementOptions.this.initial;
        }

        public long delta() {
            return DecrementOptions.this.delta;
        }

        public long cas() {
            return DecrementOptions.this.cas;
        }
    }
}

