/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.java.manager.user.AsyncUserManager;
import com.couchbase.client.java.manager.user.AuthDomain;
import com.couchbase.client.java.manager.user.DropGroupOptions;
import com.couchbase.client.java.manager.user.DropUserOptions;
import com.couchbase.client.java.manager.user.GetAllGroupsOptions;
import com.couchbase.client.java.manager.user.GetAllUsersOptions;
import com.couchbase.client.java.manager.user.GetGroupOptions;
import com.couchbase.client.java.manager.user.GetRolesOptions;
import com.couchbase.client.java.manager.user.GetUserOptions;
import com.couchbase.client.java.manager.user.Group;
import com.couchbase.client.java.manager.user.RoleAndDescription;
import com.couchbase.client.java.manager.user.UpsertGroupOptions;
import com.couchbase.client.java.manager.user.UpsertUserOptions;
import com.couchbase.client.java.manager.user.User;
import com.couchbase.client.java.manager.user.UserAndMetadata;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveUserManager {
    private final AsyncUserManager async;

    public ReactiveUserManager(AsyncUserManager async) {
        this.async = Objects.requireNonNull(async);
    }

    public Mono<UserAndMetadata> getUser(AuthDomain domain, String username) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.getUser(domain, username)));
    }

    public Mono<UserAndMetadata> getUser(AuthDomain domain, String username, GetUserOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.getUser(domain, username, options)));
    }

    public Flux<UserAndMetadata> getAllUsers() {
        return Flux.defer(() -> Reactor.toFlux(this.async::getAllUsers));
    }

    public Flux<UserAndMetadata> getAllUsers(GetAllUsersOptions options) {
        return Flux.defer(() -> Reactor.toFlux(() -> this.async.getAllUsers(options)));
    }

    public Flux<RoleAndDescription> getRoles() {
        return Flux.defer(() -> Reactor.toFlux(this.async::getRoles));
    }

    public Flux<RoleAndDescription> getRoles(GetRolesOptions options) {
        return Flux.defer(() -> Reactor.toFlux(() -> this.async.getRoles(options)));
    }

    public Mono<Void> upsertUser(User user) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.upsertUser(user)));
    }

    public Mono<Void> upsertUser(User user, UpsertUserOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.upsertUser(user, options)));
    }

    public Mono<Void> dropUser(String username) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropUser(username)));
    }

    public Mono<Void> dropUser(String username, DropUserOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropUser(username, options)));
    }

    public Mono<Group> getGroup(String groupName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.getGroup(groupName)));
    }

    public Mono<Group> getGroup(String groupName, GetGroupOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.getGroup(groupName, options)));
    }

    public Flux<Group> getAllGroups() {
        return Flux.defer(() -> Reactor.toFlux(this.async::getAllGroups));
    }

    public Flux<Group> getAllGroups(GetAllGroupsOptions options) {
        return Flux.defer(() -> Reactor.toFlux(() -> this.async.getAllGroups(options)));
    }

    public Mono<Void> upsertGroup(Group group) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.upsertGroup(group)));
    }

    public Mono<Void> upsertGroup(Group group, UpsertGroupOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.upsertGroup(group, options)));
    }

    public Mono<Void> dropGroup(String groupName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropGroup(groupName)));
    }

    public Mono<Void> dropGroup(String groupName, DropGroupOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropGroup(groupName, options)));
    }
}

