/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.encryption.databind.jackson;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.java.encryption.annotation.Encrypted;
import com.couchbase.client.java.encryption.databind.jackson.EncryptedFieldDeserializer;
import com.couchbase.client.java.encryption.databind.jackson.EncryptionModule;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import java.util.ArrayList;
import java.util.Objects;

@Stability.Internal
public class EncryptedFieldDeserializationModifier
extends BeanDeserializerModifier {
    private final CryptoManager cryptoManager;

    public EncryptedFieldDeserializationModifier(CryptoManager cryptoManager) {
        this.cryptoManager = Objects.requireNonNull(cryptoManager);
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        ArrayList modified = new ArrayList();
        ArrayList unmangledNames = new ArrayList();
        builder.getProperties().forEachRemaining(prop -> {
            Encrypted annotation = EncryptionModule.findAnnotation((BeanProperty)prop, Encrypted.class);
            if (annotation != null) {
                SettableBeanProperty newProp = prop.withName(new PropertyName(this.cryptoManager.mangle(prop.getName()))).withValueDeserializer((JsonDeserializer)new EncryptedFieldDeserializer(this.cryptoManager, annotation));
                modified.add(newProp);
                unmangledNames.add(prop.getFullName());
            }
        });
        unmangledNames.forEach(arg_0 -> ((BeanDeserializerBuilder)builder).removeProperty(arg_0));
        modified.forEach(arg_0 -> ((BeanDeserializerBuilder)builder).addProperty(arg_0));
        return builder;
    }
}

