/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.raw;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.manager.GenericManagerRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.manager.raw.RawManagerOptions;
import com.couchbase.client.java.manager.raw.RawManagerRequest;
import com.couchbase.client.java.manager.raw.RawManagerResponse;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

@Stability.Uncommitted
public class RawManager {
    public static Mono<RawManagerResponse> call(Cluster cluster, RawManagerRequest request) {
        return RawManager.call(cluster, request, RawManagerOptions.rawManagerOptions());
    }

    public static Mono<RawManagerResponse> call(Cluster cluster, RawManagerRequest request, RawManagerOptions options) {
        switch (request.serviceType()) {
            case MANAGER: {
                return RawManager.callManagement(cluster, request, options);
            }
        }
        return Mono.error((Throwable)new InvalidArgumentException("Unsupported ServiceType: " + request.serviceType(), null, null));
    }

    private static Mono<RawManagerResponse> callManagement(Cluster cluster, RawManagerRequest request, RawManagerOptions options) {
        ClusterEnvironment environment = cluster.environment();
        RawManagerOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() != null ? opts.serializer() : environment.jsonSerializer();
        Duration timeout = opts.timeout().orElse(environment.timeoutConfig().managementTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(environment.retryStrategy());
        GenericManagerRequest req = new GenericManagerRequest(timeout, cluster.core().context(), retryStrategy, () -> {
            DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, request.method(), request.uri());
            for (Map.Entry<String, Object> e : opts.httpHeaders().entrySet()) {
                httpRequest.headers().set(e.getKey(), e.getValue());
            }
            return httpRequest;
        }, request.method().equals((Object)HttpMethod.GET));
        cluster.core().send((Request)req);
        return Reactor.wrap((Request)req, (CompletableFuture)req.response(), (boolean)true).map(res -> new RawManagerResponse(request.serviceType(), serializer, res.httpStatus(), res.content()));
    }
}

