/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.InsertRequest;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.java.kv.DurabilityUtils;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Stability.Internal
public final class InsertAccessor
extends Enum<InsertAccessor> {
    private static final /* synthetic */ InsertAccessor[] $VALUES;

    public static InsertAccessor[] values() {
        return (InsertAccessor[])$VALUES.clone();
    }

    public static InsertAccessor valueOf(String name) {
        return Enum.valueOf(InsertAccessor.class, name);
    }

    public static CompletableFuture<MutationResult> insert(Core core, InsertRequest request, String key, PersistTo persistTo, ReplicateTo replicateTo) {
        core.send((Request)request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new MutationResult(response.cas(), response.mutationToken());
            }
            if (response.status() == ResponseStatus.EXISTS) {
                throw new DocumentExistsException((ErrorContext)KeyValueErrorContext.completedRequest((KeyValueRequest)request, (ResponseStatus)response.status()));
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        });
        return DurabilityUtils.wrapWithDurability(mutationResult, key, persistTo, replicateTo, core, request, false);
    }

    private static /* synthetic */ InsertAccessor[] $values() {
        return new InsertAccessor[0];
    }

    static {
        $VALUES = InsertAccessor.$values();
    }
}

