/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.GroupNotFoundException;
import com.couchbase.client.core.error.UserNotFoundException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.java.manager.ManagerSupport;
import com.couchbase.client.java.manager.user.AuthDomain;
import com.couchbase.client.java.manager.user.DropGroupOptions;
import com.couchbase.client.java.manager.user.DropUserOptions;
import com.couchbase.client.java.manager.user.GetAllGroupsOptions;
import com.couchbase.client.java.manager.user.GetAllUsersOptions;
import com.couchbase.client.java.manager.user.GetGroupOptions;
import com.couchbase.client.java.manager.user.GetRolesOptions;
import com.couchbase.client.java.manager.user.GetUserOptions;
import com.couchbase.client.java.manager.user.Group;
import com.couchbase.client.java.manager.user.Role;
import com.couchbase.client.java.manager.user.RoleAndDescription;
import com.couchbase.client.java.manager.user.UpsertGroupOptions;
import com.couchbase.client.java.manager.user.UpsertUserOptions;
import com.couchbase.client.java.manager.user.User;
import com.couchbase.client.java.manager.user.UserAndMetadata;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AsyncUserManager
extends ManagerSupport {
    public AsyncUserManager(Core core) {
        super(core);
    }

    private static String pathForUsers() {
        return "/settings/rbac/users";
    }

    private static String pathForRoles() {
        return "/settings/rbac/roles";
    }

    private static String pathForUser(AuthDomain domain, String username) {
        return AsyncUserManager.pathForUsers() + "/" + UrlQueryStringBuilder.urlEncode((String)domain.alias()) + "/" + UrlQueryStringBuilder.urlEncode((String)username);
    }

    private static String pathForGroups() {
        return "/settings/rbac/groups";
    }

    private static String pathForGroup(String name) {
        return AsyncUserManager.pathForGroups() + "/" + UrlQueryStringBuilder.urlEncode((String)name);
    }

    public CompletableFuture<UserAndMetadata> getUser(AuthDomain domain, String username) {
        return this.getUser(domain, username, GetUserOptions.getUserOptions());
    }

    public CompletableFuture<UserAndMetadata> getUser(AuthDomain domain, String username, GetUserOptions options) {
        GetUserOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_get_user", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.GET, AsyncUserManager.pathForUser(domain, username), built, span).thenApply(response -> {
            if (response.status() == ResponseStatus.NOT_FOUND) {
                throw UserNotFoundException.forUser((String)domain.alias(), (String)username);
            }
            AsyncUserManager.checkStatus(response, "get " + (Object)((Object)domain) + " user [" + RedactableArgument.redactUser((Object)username) + "]", username);
            return (UserAndMetadata)Mapper.decodeInto((byte[])response.content(), UserAndMetadata.class);
        });
    }

    public CompletableFuture<List<UserAndMetadata>> getAllUsers() {
        return this.getAllUsers(GetAllUsersOptions.getAllUsersOptions());
    }

    public CompletableFuture<List<UserAndMetadata>> getAllUsers(GetAllUsersOptions options) {
        GetAllUsersOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_get_all_users", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.GET, AsyncUserManager.pathForUsers(), built, span).thenApply(response -> {
            AsyncUserManager.checkStatus(response, "get all users", null);
            return (List)Mapper.decodeInto((byte[])response.content(), (TypeReference)new TypeReference<List<UserAndMetadata>>(){});
        });
    }

    public CompletableFuture<List<RoleAndDescription>> getRoles() {
        return this.getRoles(GetRolesOptions.getRolesOptions());
    }

    public CompletableFuture<List<RoleAndDescription>> getRoles(GetRolesOptions options) {
        GetRolesOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_get_roles", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.GET, AsyncUserManager.pathForRoles(), built, span).thenApply(response -> {
            AsyncUserManager.checkStatus(response, "get all roles", null);
            return (List)Mapper.decodeInto((byte[])response.content(), (TypeReference)new TypeReference<List<RoleAndDescription>>(){});
        });
    }

    public CompletableFuture<Void> upsertUser(User user) {
        return this.upsertUser(user, UpsertUserOptions.upsertUserOptions());
    }

    public CompletableFuture<Void> upsertUser(User user, UpsertUserOptions options) {
        UpsertUserOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_upsert_user", built.parentSpan().orElse(null));
        String username = user.username();
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("name", user.displayName()).add("roles", user.roles().stream().map(Role::format).collect(Collectors.joining(",")));
        if (!user.groups().isEmpty()) {
            params.add("groups", String.join((CharSequence)",", user.groups()));
        }
        user.password().ifPresent(pwd -> params.add("password", pwd));
        return this.sendRequest(HttpMethod.PUT, AsyncUserManager.pathForUser(AuthDomain.LOCAL, username), params, built, span).thenApply(response -> {
            AsyncUserManager.checkStatus(response, "create user [" + RedactableArgument.redactUser((Object)username) + "]", username);
            return null;
        });
    }

    public CompletableFuture<Void> dropUser(String username) {
        return this.dropUser(username, DropUserOptions.dropUserOptions());
    }

    public CompletableFuture<Void> dropUser(String username, DropUserOptions options) {
        DropUserOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_drop_user", built.parentSpan().orElse(null));
        AuthDomain domain = AuthDomain.LOCAL;
        return this.sendRequest(HttpMethod.DELETE, AsyncUserManager.pathForUser(domain, username), built, span).thenApply(response -> {
            if (response.status() == ResponseStatus.NOT_FOUND) {
                throw UserNotFoundException.forUser((String)domain.alias(), (String)username);
            }
            AsyncUserManager.checkStatus(response, "drop user [" + RedactableArgument.redactUser((Object)username) + "]", username);
            return null;
        });
    }

    public CompletableFuture<Group> getGroup(String groupName) {
        return this.getGroup(groupName, GetGroupOptions.getGroupOptions());
    }

    public CompletableFuture<Group> getGroup(String groupName, GetGroupOptions options) {
        GetGroupOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_get_group", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.GET, AsyncUserManager.pathForGroup(groupName), built, span).thenApply(response -> {
            if (response.status() == ResponseStatus.NOT_FOUND) {
                throw GroupNotFoundException.forGroup((String)groupName);
            }
            AsyncUserManager.checkStatus(response, "get group [" + RedactableArgument.redactMeta((Object)groupName) + "]", groupName);
            return (Group)Mapper.decodeInto((byte[])response.content(), Group.class);
        });
    }

    public CompletableFuture<List<Group>> getAllGroups() {
        return this.getAllGroups(GetAllGroupsOptions.getAllGroupsOptions());
    }

    public CompletableFuture<List<Group>> getAllGroups(GetAllGroupsOptions options) {
        GetAllGroupsOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_get_all_groups", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.GET, AsyncUserManager.pathForGroups(), built, span).thenApply(response -> {
            AsyncUserManager.checkStatus(response, "get all groups", null);
            return (List)Mapper.decodeInto((byte[])response.content(), (TypeReference)new TypeReference<List<Group>>(){});
        });
    }

    public CompletableFuture<Void> upsertGroup(Group group) {
        return this.upsertGroup(group, UpsertGroupOptions.upsertGroupOptions());
    }

    public CompletableFuture<Void> upsertGroup(Group group, UpsertGroupOptions options) {
        UpsertGroupOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_upsert_group", built.parentSpan().orElse(null));
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("description", group.description()).add("ldap_group_ref", group.ldapGroupReference().orElse("")).add("roles", group.roles().stream().map(Role::format).collect(Collectors.joining(",")));
        return this.sendRequest(HttpMethod.PUT, AsyncUserManager.pathForGroup(group.name()), params, built, span).thenApply(response -> {
            AsyncUserManager.checkStatus(response, "create group [" + RedactableArgument.redactMeta((Object)group.name()) + "]", group.name());
            return null;
        });
    }

    public CompletableFuture<Void> dropGroup(String groupName) {
        return this.dropGroup(groupName, DropGroupOptions.dropGroupOptions());
    }

    public CompletableFuture<Void> dropGroup(String groupName, DropGroupOptions options) {
        DropGroupOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_users_drop_group", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.DELETE, AsyncUserManager.pathForGroup(groupName), built, span).thenApply(response -> {
            if (response.status() == ResponseStatus.NOT_FOUND) {
                throw GroupNotFoundException.forGroup((String)groupName);
            }
            AsyncUserManager.checkStatus(response, "drop group [" + RedactableArgument.redactMeta((Object)groupName) + "]", groupName);
            return null;
        });
    }

    private RequestSpan buildSpan(String spanName, RequestSpan parent) {
        RequestSpan span = this.environment().requestTracer().requestSpan(spanName, parent);
        span.setAttribute("db.system", "couchbase");
        return span;
    }
}

