/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.java.manager.eventing.EventingFunctionDeploymentStatus;
import com.couchbase.client.java.manager.eventing.EventingFunctionProcessingStatus;
import com.couchbase.client.java.manager.eventing.EventingFunctionStatus;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventingFunctionState {
    private final String name;
    private final EventingFunctionStatus status;
    private final long numBootstrappingNodes;
    private final long numDeployedNodes;
    private final EventingFunctionDeploymentStatus deploymentStatus;
    private final EventingFunctionProcessingStatus processingStatus;

    public EventingFunctionState(@JsonProperty(value="name") String name, @JsonProperty(value="composite_status") EventingFunctionStatus status, @JsonProperty(value="num_bootstrapping_nodes") long numBootstrappingNodes, @JsonProperty(value="num_deployed_nodes") long numDeployedNodes, @JsonProperty(value="deployment_status") boolean deploymentStatus, @JsonProperty(value="processing_status") boolean processingStatus) {
        this.name = name;
        this.status = status;
        this.numBootstrappingNodes = numBootstrappingNodes;
        this.numDeployedNodes = numDeployedNodes;
        this.deploymentStatus = deploymentStatus ? EventingFunctionDeploymentStatus.DEPLOYED : EventingFunctionDeploymentStatus.UNDEPLOYED;
        this.processingStatus = processingStatus ? EventingFunctionProcessingStatus.RUNNING : EventingFunctionProcessingStatus.PAUSED;
    }

    public String name() {
        return this.name;
    }

    public EventingFunctionStatus status() {
        return this.status;
    }

    public long numBootstrappingNodes() {
        return this.numBootstrappingNodes;
    }

    public long numDeployedNodes() {
        return this.numDeployedNodes;
    }

    public EventingFunctionDeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public EventingFunctionProcessingStatus processingStatus() {
        return this.processingStatus;
    }

    public String toString() {
        return "EventingFunctionState{name='" + this.name + '\'' + ", status=" + (Object)((Object)this.status) + ", numBootstrappingNodes=" + this.numBootstrappingNodes + ", numDeployedNodes=" + this.numDeployedNodes + ", deploymentStatus=" + (Object)((Object)this.deploymentStatus) + ", processingStatus=" + (Object)((Object)this.processingStatus) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventingFunctionState that = (EventingFunctionState)o;
        return this.numBootstrappingNodes == that.numBootstrappingNodes && this.numDeployedNodes == that.numDeployedNodes && Objects.equals(this.name, that.name) && this.status == that.status && this.deploymentStatus == that.deploymentStatus && this.processingStatus == that.processingStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.status, this.numBootstrappingNodes, this.numDeployedNodes, this.deploymentStatus, this.processingStatus});
    }
}

