/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.GetAndLockRequest;
import com.couchbase.client.core.msg.kv.GetAndTouchRequest;
import com.couchbase.client.core.msg.kv.GetMetaRequest;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.InsertRequest;
import com.couchbase.client.core.msg.kv.RemoveRequest;
import com.couchbase.client.core.msg.kv.ReplaceRequest;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocMutateRequest;
import com.couchbase.client.core.msg.kv.TouchRequest;
import com.couchbase.client.core.msg.kv.UnlockRequest;
import com.couchbase.client.core.msg.kv.UpsertRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.kv.ReplicaHelper;
import com.couchbase.client.core.util.BucketConfigUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.ExistsAccessor;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import com.couchbase.client.java.kv.Expiry;
import com.couchbase.client.java.kv.GetAccessor;
import com.couchbase.client.java.kv.GetAllReplicasOptions;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetReplicaResult;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertAccessor;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInAccessor;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInAccessor;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RemoveAccessor;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceAccessor;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.StoreSemantics;
import com.couchbase.client.java.kv.TouchAccessor;
import com.couchbase.client.java.kv.TouchOptions;
import com.couchbase.client.java.kv.UnlockAccessor;
import com.couchbase.client.java.kv.UnlockOptions;
import com.couchbase.client.java.kv.UpsertAccessor;
import com.couchbase.client.java.kv.UpsertOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCollection {
    private final Core core;
    private final CoreContext coreContext;
    private final ClusterEnvironment environment;
    private final String name;
    private final String bucket;
    private final String scopeName;
    private final AsyncBinaryCollection asyncBinaryCollection;
    private final CollectionIdentifier collectionIdentifier;

    AsyncCollection(String name, String scopeName, String bucket, Core core, ClusterEnvironment environment) {
        this.name = name;
        this.scopeName = scopeName;
        this.core = core;
        this.coreContext = core.context();
        this.environment = environment;
        this.bucket = bucket;
        this.collectionIdentifier = new CollectionIdentifier(bucket, Optional.of(scopeName), Optional.of(name));
        this.asyncBinaryCollection = new AsyncBinaryCollection(core, environment, this.collectionIdentifier);
    }

    @Stability.Volatile
    public Core core() {
        return this.core;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    public String name() {
        return this.name;
    }

    public String bucketName() {
        return this.bucket;
    }

    public String scopeName() {
        return this.scopeName;
    }

    public AsyncBinaryCollection binary() {
        return this.asyncBinaryCollection;
    }

    public CompletableFuture<GetResult> get(String id) {
        return this.get(id, ReactiveCollection.DEFAULT_GET_OPTIONS);
    }

    public CompletableFuture<GetResult> get(String id, GetOptions options) {
        Transcoder transcoder;
        Validators.notNull((Object)options, (String)"GetOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        GetOptions.Built opts = options.build();
        Transcoder transcoder2 = transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        if (opts.projections().isEmpty() && !opts.withExpiry()) {
            return GetAccessor.get(this.core, this.fullGetRequest(id, opts), transcoder);
        }
        return GetAccessor.subdocGet(this.core, this.subdocGetRequest(id, opts), transcoder);
    }

    @Stability.Internal
    GetRequest fullGetRequest(String id, GetOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("get", (RequestSpan)opts.parentSpan().orElse(null));
        GetRequest request = new GetRequest(id, timeout, this.coreContext, this.collectionIdentifier, retryStrategy, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    @Stability.Internal
    SubdocGetRequest subdocGetRequest(String id, GetOptions.Built opts) {
        try {
            Validators.notNullOrEmpty((String)id, (String)"Id");
            if (opts.withExpiry()) {
                if (opts.projections().size() > 15) {
                    throw InvalidArgumentException.fromMessage((String)"Only a maximum of 16 fields can be projected per request due to a server limitation (includes the expiration macro as one field).");
                }
            } else if (opts.projections().size() > 16) {
                throw InvalidArgumentException.fromMessage((String)"Only a maximum of 16 fields can be projected per request due to a server limitation.");
            }
        }
        catch (Exception cause) {
            throw new InvalidArgumentException("Argument validation failed", (Throwable)cause, (ErrorContext)ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        }
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        ArrayList<SubdocGetRequest.Command> commands = new ArrayList<SubdocGetRequest.Command>(16);
        if (!opts.projections().isEmpty()) {
            if (opts.projections().size() > 16) {
                throw new UnsupportedOperationException("Only a maximum of 16 fields can be projected per request.");
            }
            List<String> projections = opts.projections();
            for (int i = 0; i < projections.size(); ++i) {
                commands.add(new SubdocGetRequest.Command(SubdocCommandType.GET, projections.get(i), false, commands.size()));
            }
        } else {
            commands.add(new SubdocGetRequest.Command(SubdocCommandType.GET_DOC, "", false, commands.size()));
        }
        if (opts.withExpiry()) {
            commands.add(0, new SubdocGetRequest.Command(SubdocCommandType.GET, "$document.exptime", true, commands.size()));
            if (opts.projections().isEmpty()) {
                commands.add(1, new SubdocGetRequest.Command(SubdocCommandType.GET, "$document.flags", true, commands.size()));
            }
        }
        RequestSpan span = this.environment.requestTracer().requestSpan("lookup_in", (RequestSpan)opts.parentSpan().orElse(null));
        SubdocGetRequest request = new SubdocGetRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, 0, commands, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<GetResult> getAndLock(String id, Duration lockTime) {
        return this.getAndLock(id, lockTime, ReactiveCollection.DEFAULT_GET_AND_LOCK_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        Validators.notNull((Object)options, (String)"GetAndLockOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        GetAndLockOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return GetAccessor.getAndLock(this.core, this.getAndLockRequest(id, lockTime, opts), transcoder);
    }

    @Stability.Internal
    GetAndLockRequest getAndLockRequest(String id, Duration lockTime, GetAndLockOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)lockTime, (String)"LockTime", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("get_and_lock", (RequestSpan)opts.parentSpan().orElse(null));
        GetAndLockRequest request = new GetAndLockRequest(id, timeout, this.coreContext, this.collectionIdentifier, retryStrategy, lockTime, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Duration expiry) {
        return this.getAndTouch(id, expiry, ReactiveCollection.DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        Validators.notNull((Object)expiry, (String)"Expiry", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)options, (String)"GetAndTouchOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        GetAndTouchOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return GetAccessor.getAndTouch(this.core, this.getAndTouchRequest(id, Expiry.relative(expiry), opts), transcoder);
    }

    @Stability.Internal
    GetAndTouchRequest getAndTouchRequest(String id, Expiry expiry, GetAndTouchOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)expiry, (String)"Expiry", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("get_and_touch", (RequestSpan)opts.parentSpan().orElse(null));
        long encodedExpiry = expiry.encode();
        GetAndTouchRequest request = new GetAndTouchRequest(id, timeout, this.coreContext, this.collectionIdentifier, retryStrategy, encodedExpiry, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<List<CompletableFuture<GetReplicaResult>>> getAllReplicas(String id) {
        return this.getAllReplicas(id, ReactiveCollection.DEFAULT_GET_ALL_REPLICAS_OPTIONS);
    }

    public CompletableFuture<List<CompletableFuture<GetReplicaResult>>> getAllReplicas(String id, GetAllReplicasOptions options) {
        Validators.notNull((Object)options, (String)"GetAllReplicasOptions");
        GetAllReplicasOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return ReplicaHelper.getAllReplicasAsync((Core)this.core, (CollectionIdentifier)this.collectionIdentifier, (String)id, (Duration)opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), (RetryStrategy)opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), (RequestSpan)opts.parentSpan().orElse(null), response -> GetReplicaResult.from(response, transcoder));
    }

    public CompletableFuture<GetReplicaResult> getAnyReplica(String id) {
        return this.getAnyReplica(id, ReactiveCollection.DEFAULT_GET_ANY_REPLICA_OPTIONS);
    }

    public CompletableFuture<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)options, (String)"GetAnyReplicaOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        GetAnyReplicaOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return ReplicaHelper.getAnyReplicaAsync((Core)this.core, (CollectionIdentifier)this.collectionIdentifier, (String)id, (Duration)opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), (RetryStrategy)opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), (RequestSpan)opts.parentSpan().orElse(null), response -> GetReplicaResult.from(response, transcoder));
    }

    public CompletableFuture<ExistsResult> exists(String id) {
        return this.exists(id, ReactiveCollection.DEFAULT_EXISTS_OPTIONS);
    }

    public CompletableFuture<ExistsResult> exists(String id, ExistsOptions options) {
        return ExistsAccessor.exists(id, this.core, this.existsRequest(id, options));
    }

    GetMetaRequest existsRequest(String id, ExistsOptions options) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)options, (String)"ExistsOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        ExistsOptions.Built opts = options.build();
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("exists", (RequestSpan)opts.parentSpan().orElse(null));
        GetMetaRequest request = new GetMetaRequest(id, timeout, this.coreContext, this.collectionIdentifier, retryStrategy, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<MutationResult> remove(String id) {
        return this.remove(id, ReactiveCollection.DEFAULT_REMOVE_OPTIONS);
    }

    public CompletableFuture<MutationResult> remove(String id, RemoveOptions options) {
        Validators.notNull((Object)options, (String)"RemoveOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        RemoveOptions.Built opts = options.build();
        return RemoveAccessor.remove(this.core, this.removeRequest(id, opts), id, opts.persistTo(), opts.replicateTo());
    }

    RemoveRequest removeRequest(String id, RemoveOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("remove", (RequestSpan)opts.parentSpan().orElse(null));
        RemoveRequest request = new RemoveRequest(id, opts.cas(), timeout, this.coreContext, this.collectionIdentifier, retryStrategy, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<MutationResult> insert(String id, Object content) {
        return this.insert(id, content, ReactiveCollection.DEFAULT_INSERT_OPTIONS);
    }

    public CompletableFuture<MutationResult> insert(String id, Object content, InsertOptions options) {
        Validators.notNull((Object)options, (String)"InsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        InsertOptions.Built opts = options.build();
        return InsertAccessor.insert(this.core, this.insertRequest(id, content, opts), id, opts.persistTo(), opts.replicateTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InsertRequest insertRequest(String id, Object content, InsertOptions.Built opts) {
        Transcoder.EncodedValue encoded;
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        RequestSpan span = this.environment.requestTracer().requestSpan("insert", (RequestSpan)opts.parentSpan().orElse(null));
        RequestSpan encodeSpan = this.environment.requestTracer().requestSpan("request_encoding", span);
        long start = System.nanoTime();
        try {
            encoded = transcoder.encode(content);
        }
        finally {
            encodeSpan.end();
        }
        long end = System.nanoTime();
        long expiry = opts.expiry().encode();
        InsertRequest request = new InsertRequest(id, encoded.encoded(), expiry, encoded.flags(), timeout, this.coreContext, this.collectionIdentifier, retryStrategy, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext()).encodeLatency(end - start);
        return request;
    }

    public CompletableFuture<MutationResult> upsert(String id, Object content) {
        return this.upsert(id, content, ReactiveCollection.DEFAULT_UPSERT_OPTIONS);
    }

    public CompletableFuture<MutationResult> upsert(String id, Object content, UpsertOptions options) {
        Validators.notNull((Object)options, (String)"UpsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        UpsertOptions.Built opts = options.build();
        return UpsertAccessor.upsert(this.core, this.upsertRequest(id, content, opts), id, opts.persistTo(), opts.replicateTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpsertRequest upsertRequest(String id, Object content, UpsertOptions.Built opts) {
        Transcoder.EncodedValue encoded;
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        RequestSpan span = this.environment.requestTracer().requestSpan("upsert", (RequestSpan)opts.parentSpan().orElse(null));
        RequestSpan encodeSpan = this.environment.requestTracer().requestSpan("request_encoding", span);
        long start = System.nanoTime();
        try {
            encoded = transcoder.encode(content);
        }
        finally {
            encodeSpan.end();
        }
        long end = System.nanoTime();
        long expiry = opts.expiry().encode();
        UpsertRequest request = new UpsertRequest(id, encoded.encoded(), expiry, opts.preserveExpiry(), encoded.flags(), timeout, this.coreContext, this.collectionIdentifier, retryStrategy, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext()).encodeLatency(end - start);
        return request;
    }

    public CompletableFuture<MutationResult> replace(String id, Object content) {
        return this.replace(id, content, ReactiveCollection.DEFAULT_REPLACE_OPTIONS);
    }

    public CompletableFuture<MutationResult> replace(String id, Object content, ReplaceOptions options) {
        Validators.notNull((Object)options, (String)"ReplaceOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        ReplaceOptions.Built opts = options.build();
        return ReplaceAccessor.replace(this.core, this.replaceRequest(id, content, opts), id, opts.persistTo(), opts.replicateTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplaceRequest replaceRequest(String id, Object content, ReplaceOptions.Built opts) {
        Transcoder.EncodedValue encoded;
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        RequestSpan span = this.environment.requestTracer().requestSpan("replace", (RequestSpan)opts.parentSpan().orElse(null));
        RequestSpan encodeSpan = this.environment.requestTracer().requestSpan("request_encoding", span);
        long start = System.nanoTime();
        try {
            encoded = transcoder.encode(content);
        }
        finally {
            encodeSpan.end();
        }
        long end = System.nanoTime();
        long expiry = opts.expiry().encode();
        ReplaceRequest request = new ReplaceRequest(id, encoded.encoded(), expiry, opts.preserveExpiry(), encoded.flags(), timeout, opts.cas(), this.coreContext, this.collectionIdentifier, retryStrategy, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext()).encodeLatency(end - start);
        return request;
    }

    public CompletableFuture<MutationResult> touch(String id, Duration expiry) {
        return this.touch(id, expiry, ReactiveCollection.DEFAULT_TOUCH_OPTIONS);
    }

    public CompletableFuture<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        Validators.notNull((Object)expiry, (String)"Expiry", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        return TouchAccessor.touch(this.core, this.touchRequest(id, Expiry.relative(expiry), options), id);
    }

    TouchRequest touchRequest(String id, Expiry expiry, TouchOptions options) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)expiry, (String)"Expiry", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)options, (String)"TouchOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        TouchOptions.Built opts = options.build();
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("touch", (RequestSpan)opts.parentSpan().orElse(null));
        long encodedExpiry = expiry.encode();
        TouchRequest request = new TouchRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, encodedExpiry, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<Void> unlock(String id, long cas) {
        return this.unlock(id, cas, ReactiveCollection.DEFAULT_UNLOCK_OPTIONS);
    }

    public CompletableFuture<Void> unlock(String id, long cas, UnlockOptions options) {
        return UnlockAccessor.unlock(id, this.core, this.unlockRequest(id, cas, options));
    }

    UnlockRequest unlockRequest(String id, long cas, UnlockOptions options) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)options, (String)"UnlockOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        if (cas == 0L) {
            throw new InvalidArgumentException("CAS cannot be 0", null, (ErrorContext)ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        }
        UnlockOptions.Built opts = options.build();
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("unlock", (RequestSpan)opts.parentSpan().orElse(null));
        UnlockRequest request = new UnlockRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, cas, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<LookupInResult> lookupIn(String id, List<LookupInSpec> specs) {
        return this.lookupIn(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_OPTIONS);
    }

    public CompletableFuture<LookupInResult> lookupIn(String id, List<LookupInSpec> specs, LookupInOptions options) {
        Validators.notNull((Object)options, (String)"LookupInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        LookupInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return LookupInAccessor.lookupInAccessor(this.core, this.lookupInRequest(id, specs, opts), serializer);
    }

    SubdocGetRequest lookupInRequest(String id, List<LookupInSpec> specs, LookupInOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNullOrEmpty(specs, (String)"LookupInSpecs", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        ArrayList<SubdocGetRequest.Command> commands = new ArrayList<SubdocGetRequest.Command>(specs.size());
        for (int i = 0; i < specs.size(); ++i) {
            LookupInSpec spec = specs.get(i);
            commands.add(spec.export(i));
        }
        commands.sort(Comparator.comparing(v -> !v.xattr()));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        byte flags = 0;
        if (opts.accessDeleted()) {
            flags = (byte)(flags | 4);
        }
        RequestSpan span = this.environment.requestTracer().requestSpan("lookup_in", (RequestSpan)opts.parentSpan().orElse(null));
        SubdocGetRequest request = new SubdocGetRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, flags, commands, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<MutateInResult> mutateIn(String id, List<MutateInSpec> specs) {
        return this.mutateIn(id, specs, ReactiveCollection.DEFAULT_MUTATE_IN_OPTIONS);
    }

    public CompletableFuture<MutateInResult> mutateIn(String id, List<MutateInSpec> specs, MutateInOptions options) {
        Validators.notNull((Object)options, (String)"MutateInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        MutateInOptions.Built opts = options.build();
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        return this.mutateInRequest(id, specs, opts, timeout).thenCompose(request -> MutateInAccessor.mutateIn(this.core, request, id, opts.persistTo(), opts.replicateTo(), opts.storeSemantics() == StoreSemantics.INSERT, this.environment.jsonSerializer()));
    }

    CompletableFuture<SubdocMutateRequest> mutateInRequest(String id, List<MutateInSpec> specs, MutateInOptions.Built opts, Duration timeout) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNullOrEmpty(specs, (String)"MutateInSpecs", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        if (specs.isEmpty()) {
            throw SubdocMutateRequest.errIfNoCommands((ErrorContext)ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        }
        if (specs.size() > 16) {
            throw SubdocMutateRequest.errIfTooManyCommands((ErrorContext)ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        }
        boolean requiresBucketConfig = opts.createAsDeleted();
        CompletableFuture bucketConfigFuture = requiresBucketConfig ? BucketConfigUtil.waitForBucketConfig((Core)this.core, (String)this.bucketName(), (Duration)timeout).toFuture() : CompletableFuture.completedFuture(null);
        return bucketConfigFuture.thenCompose(bucketConfig -> {
            RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
            JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
            RequestSpan span = this.environment.requestTracer().requestSpan("mutate_in", (RequestSpan)opts.parentSpan().orElse(null));
            ArrayList<SubdocMutateRequest.Command> commands = new ArrayList<SubdocMutateRequest.Command>(specs.size());
            RequestSpan encodeSpan = this.environment.requestTracer().requestSpan("request_encoding", span);
            long start = System.nanoTime();
            try {
                for (int i = 0; i < specs.size(); ++i) {
                    MutateInSpec spec = (MutateInSpec)specs.get(i);
                    commands.add(spec.encode(serializer, i));
                }
            }
            finally {
                encodeSpan.end();
            }
            long end = System.nanoTime();
            commands.sort(Comparator.comparing(v -> !v.xattr()));
            long expiry = opts.expiry().encode();
            SubdocMutateRequest request = new SubdocMutateRequest(timeout, this.coreContext, this.collectionIdentifier, bucketConfig, retryStrategy, id, opts.storeSemantics() == StoreSemantics.INSERT, opts.storeSemantics() == StoreSemantics.UPSERT, opts.storeSemantics() == StoreSemantics.REVIVE, opts.accessDeleted(), opts.createAsDeleted(), commands, expiry, opts.preserveExpiry(), opts.cas(), opts.durabilityLevel(), span);
            request.context().clientContext(opts.clientContext()).encodeLatency(end - start);
            CompletableFuture<SubdocMutateRequest> future = new CompletableFuture<SubdocMutateRequest>();
            future.complete(request);
            return future;
        });
    }

    static Duration decideKvTimeout(CommonDurabilityOptions.BuiltCommonDurabilityOptions opts, TimeoutConfig config) {
        boolean pollDurability;
        Optional<Duration> userTimeout = opts.timeout();
        if (userTimeout.isPresent()) {
            return userTimeout.get();
        }
        boolean syncDurability = opts.durabilityLevel().isPresent() && (opts.durabilityLevel().get() == DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE || opts.durabilityLevel().get() == DurabilityLevel.PERSIST_TO_MAJORITY);
        boolean bl = pollDurability = opts.persistTo() != PersistTo.NONE;
        if (syncDurability || pollDurability) {
            return config.kvDurableTimeout();
        }
        return config.kvTimeout();
    }

    CollectionIdentifier collectionIdentifier() {
        return this.collectionIdentifier;
    }
}

