/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import java.util.Optional;

public class DropPrimaryQueryIndexOptions
extends CommonOptions<DropPrimaryQueryIndexOptions> {
    private boolean ignoreIfNotExists;
    private String scopeName;
    private String collectionName;

    private DropPrimaryQueryIndexOptions() {
    }

    public static DropPrimaryQueryIndexOptions dropPrimaryQueryIndexOptions() {
        return new DropPrimaryQueryIndexOptions();
    }

    public DropPrimaryQueryIndexOptions ignoreIfNotExists(boolean ignore) {
        this.ignoreIfNotExists = ignore;
        return this;
    }

    @Stability.Uncommitted
    public DropPrimaryQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty((String)scopeName, (String)"ScopeName");
        return this;
    }

    @Stability.Uncommitted
    public DropPrimaryQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty((String)collectionName, (String)"CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
            super(DropPrimaryQueryIndexOptions.this);
        }

        public boolean ignoreIfNotExists() {
            return DropPrimaryQueryIndexOptions.this.ignoreIfNotExists;
        }

        public Optional<String> scopeName() {
            return Optional.ofNullable(DropPrimaryQueryIndexOptions.this.scopeName);
        }

        public Optional<String> collectionName() {
            return Optional.ofNullable(DropPrimaryQueryIndexOptions.this.collectionName);
        }
    }
}

