/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.TextNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.msg.search.SearchResponse;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.search.SearchMetaData;
import com.couchbase.client.java.search.result.DateRangeSearchFacetResult;
import com.couchbase.client.java.search.result.NumericRangeSearchFacetResult;
import com.couchbase.client.java.search.result.ReactiveSearchResult;
import com.couchbase.client.java.search.result.SearchFacetResult;
import com.couchbase.client.java.search.result.SearchMetrics;
import com.couchbase.client.java.search.result.SearchResult;
import com.couchbase.client.java.search.result.SearchRow;
import com.couchbase.client.java.search.result.SearchStatus;
import com.couchbase.client.java.search.result.TermSearchFacetResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public class SearchAccessor {
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};

    public static CompletableFuture<SearchResult> searchQueryAsync(Core core, SearchRequest request, JsonSerializer serializer) {
        core.send((Request)request);
        return Mono.fromFuture((CompletableFuture)request.response()).flatMap(response -> response.rows().map(row -> SearchRow.fromResponse(row, serializer)).collectList().flatMap(rows -> response.trailer().map(trailer -> new SearchResult((List<SearchRow>)rows, SearchAccessor.parseFacets(trailer), SearchAccessor.parseMeta(response, trailer))))).doOnNext(ignored -> request.context().logicallyComplete()).doOnError(err -> request.context().logicallyComplete(err)).toFuture();
    }

    public static Mono<ReactiveSearchResult> searchQueryReactive(Core core, SearchRequest request, JsonSerializer serializer) {
        core.send((Request)request);
        return Mono.fromFuture((CompletableFuture)request.response()).map(response -> {
            Flux rows = response.rows().map(row -> SearchRow.fromResponse(row, serializer));
            Mono meta = response.trailer().map(trailer -> SearchAccessor.parseMeta(response, trailer));
            Mono facets = response.trailer().map(SearchAccessor::parseFacets);
            return new ReactiveSearchResult((Flux<SearchRow>)rows, (Mono<Map<String, SearchFacetResult>>)facets, (Mono<SearchMetaData>)meta);
        }).doOnNext(ignored -> request.context().logicallyComplete()).doOnError(err -> request.context().logicallyComplete(err));
    }

    private static Map<String, SearchFacetResult> parseFacets(SearchChunkTrailer trailer) {
        byte[] rawFacets = trailer.facets();
        if (rawFacets == null || rawFacets.length == 0 || Arrays.equals(rawFacets, NULL)) {
            return Collections.emptyMap();
        }
        ObjectNode objectNode = (ObjectNode)Mapper.decodeIntoTree((byte[])rawFacets);
        HashMap<String, SearchFacetResult> facets = new HashMap<String, SearchFacetResult>();
        SearchAccessor.forEachField(objectNode, (facetName, facetEntry) -> {
            ((ObjectNode)facetEntry).set("$name", (JsonNode)new TextNode(facetName));
            if (facetEntry.has("numeric_ranges")) {
                facets.put((String)facetName, (SearchFacetResult)Mapper.convertValue((Object)facetEntry, NumericRangeSearchFacetResult.class));
            } else if (facetEntry.has("date_ranges")) {
                facets.put((String)facetName, (SearchFacetResult)Mapper.convertValue((Object)facetEntry, DateRangeSearchFacetResult.class));
            } else {
                facets.put((String)facetName, (SearchFacetResult)Mapper.convertValue((Object)facetEntry, TermSearchFacetResult.class));
            }
        });
        return facets;
    }

    private static void forEachField(ObjectNode node, BiConsumer<String, JsonNode> consumer) {
        Objects.requireNonNull(consumer);
        node.fields().forEachRemaining(entry -> consumer.accept((String)entry.getKey(), (JsonNode)entry.getValue()));
    }

    private static SearchMetaData parseMeta(SearchResponse response, SearchChunkTrailer trailer) {
        SearchStatus status = (SearchStatus)Mapper.decodeInto((byte[])response.header().getStatus(), SearchStatus.class);
        SearchMetrics metrics = new SearchMetrics(trailer.took(), trailer.totalRows(), trailer.maxScore(), status.successCount(), status.errorCount());
        return new SearchMetaData(status.errors(), metrics);
    }
}

