/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.context.ReducedAnalyticsErrorContext;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.analytics.AnalyticsAccessor;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryAccessor;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncScope {
    private final Core core;
    private final String bucketName;
    private final String scopeName;
    private final ClusterEnvironment environment;
    final CoreQueryOps queryOps;
    final CoreQueryContext queryContext;
    private final Map<String, AsyncCollection> collectionCache = new ConcurrentHashMap<String, AsyncCollection>();

    AsyncScope(String scopeName, String bucketName, Core core, ClusterEnvironment environment) {
        this.scopeName = scopeName;
        this.bucketName = bucketName;
        this.core = core;
        this.environment = environment;
        this.queryOps = core.queryOps();
        this.queryContext = CoreQueryContext.of((String)bucketName, (String)scopeName);
    }

    public String name() {
        return this.scopeName;
    }

    public String bucketName() {
        return this.bucketName;
    }

    @Stability.Volatile
    public Core core() {
        return this.core;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    AsyncCollection defaultCollection() {
        return this.maybeCreateAsyncCollection("_default", !this.scopeName.equals("_default"));
    }

    public AsyncCollection collection(String collectionName) {
        boolean defaultScopeAndCollection = collectionName.equals("_default") && this.scopeName.equals("_default");
        return this.maybeCreateAsyncCollection(collectionName, !defaultScopeAndCollection);
    }

    private AsyncCollection maybeCreateAsyncCollection(String collectionName, boolean refreshMap) {
        return this.collectionCache.computeIfAbsent(collectionName, name -> {
            if (refreshMap) {
                this.core.configurationProvider().refreshCollectionId(new CollectionIdentifier(this.bucketName, Optional.of(this.scopeName), Optional.of(name)));
            }
            return new AsyncCollection((String)name, this.scopeName, this.bucketName, this.core, this.environment);
        });
    }

    public CompletableFuture<QueryResult> query(String statement) {
        return this.query(statement, ReactiveCluster.DEFAULT_QUERY_OPTIONS);
    }

    public CompletableFuture<QueryResult> query(String statement, QueryOptions options) {
        Validators.notNull((Object)options, (String)"QueryOptions", () -> new ReducedQueryErrorContext(statement));
        QueryOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return this.queryOps.queryAsync(statement, (CoreQueryOptions)opts, this.queryContext, null, QueryAccessor::convertCoreQueryError).thenApply(r -> new QueryResult((CoreQueryResult)r, serializer));
    }

    public CompletableFuture<AnalyticsResult> analyticsQuery(String statement) {
        return this.analyticsQuery(statement, ReactiveCluster.DEFAULT_ANALYTICS_OPTIONS);
    }

    public CompletableFuture<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"AnalyticsOptions", () -> new ReducedAnalyticsErrorContext(statement));
        AnalyticsOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return AnalyticsAccessor.analyticsQueryAsync(this.core, this.analyticsRequest(statement, opts), serializer);
    }

    AnalyticsRequest analyticsRequest(String statement, AnalyticsOptions.Built opts) {
        Validators.notNullOrEmpty((String)statement, (String)"Statement", () -> new ReducedAnalyticsErrorContext(statement));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().analyticsTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        JsonObject query = JsonObject.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs((Duration)timeout));
        query.put("query_context", AnalyticsRequest.queryContext((String)this.bucketName, (String)this.scopeName));
        opts.injectParams(query);
        byte[] queryBytes = query.toString().getBytes(StandardCharsets.UTF_8);
        String clientContextId = query.getString("client_context_id");
        RequestSpan span = this.environment().requestTracer().requestSpan("analytics", (RequestSpan)opts.parentSpan().orElse(null));
        AnalyticsRequest request = new AnalyticsRequest(timeout, this.core.context(), retryStrategy, this.core.context().authenticator(), queryBytes, opts.priority(), opts.readonly(), clientContextId, statement, span, this.bucketName, this.scopeName);
        request.context().clientContext(opts.clientContext());
        return request;
    }
}

