/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.vector;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.vector.CoreVectorQuery;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class VectorQuery {
    private final float[] vectorQuery;
    private final String vectorField;
    @Nullable
    private Integer numCandidates;
    @Nullable
    private Double boost;

    private VectorQuery(String vectorField, float[] vectorQuery) {
        this.vectorField = vectorField;
        this.vectorQuery = vectorQuery;
    }

    public static VectorQuery create(String vectorField, float[] vectorQuery) {
        return new VectorQuery(vectorField, vectorQuery);
    }

    public VectorQuery numCandidates(int numCandidates) {
        this.numCandidates = numCandidates;
        return this;
    }

    public VectorQuery boost(double boost) {
        this.boost = boost;
        return this;
    }

    @Stability.Internal
    public CoreVectorQuery toCore() {
        return new CoreVectorQuery(this.vectorQuery, this.vectorField, this.numCandidates, this.boost);
    }
}

