/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.manager.query.AsyncCollectionQueryIndexManager;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class ReactiveCollectionQueryIndexManager {
    private final AsyncCollectionQueryIndexManager async;

    @Stability.Internal
    public ReactiveCollectionQueryIndexManager(AsyncCollectionQueryIndexManager async) {
        this.async = Objects.requireNonNull(async);
    }

    public Mono<Void> createIndex(String indexName, Collection<String> fields) {
        return Reactor.toMono(() -> this.async.createIndex(indexName, fields));
    }

    public Mono<Void> createIndex(String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        return Reactor.toMono(() -> this.async.createIndex(indexName, fields, options));
    }

    public Mono<Void> createPrimaryIndex() {
        return Reactor.toMono(() -> this.async.createPrimaryIndex());
    }

    public Mono<Void> createPrimaryIndex(CreatePrimaryQueryIndexOptions options) {
        return Reactor.toMono(() -> this.async.createPrimaryIndex(options));
    }

    public Flux<QueryIndex> getAllIndexes() {
        return Reactor.toFlux(() -> this.async.getAllIndexes());
    }

    public Flux<QueryIndex> getAllIndexes(GetAllQueryIndexesOptions options) {
        return Reactor.toFlux(() -> this.async.getAllIndexes(options));
    }

    public Mono<Void> dropPrimaryIndex() {
        return Reactor.toMono(() -> this.async.dropPrimaryIndex());
    }

    public Mono<Void> dropPrimaryIndex(DropPrimaryQueryIndexOptions options) {
        return Reactor.toMono(() -> this.async.dropPrimaryIndex(options));
    }

    public Mono<Void> dropIndex(String indexName) {
        return Reactor.toMono(() -> this.async.dropIndex(indexName));
    }

    public Mono<Void> dropIndex(String indexName, DropQueryIndexOptions options) {
        return Reactor.toMono(() -> this.async.dropIndex(indexName, options));
    }

    public Mono<Void> buildDeferredIndexes() {
        return Reactor.toMono(() -> this.async.buildDeferredIndexes());
    }

    public Mono<Void> buildDeferredIndexes(BuildQueryIndexOptions options) {
        return Reactor.toMono(() -> this.async.buildDeferredIndexes(options));
    }

    public Mono<Void> watchIndexes(Collection<String> indexNames, Duration timeout) {
        return Reactor.toMono(() -> this.async.watchIndexes(indexNames, timeout));
    }

    public Mono<Void> watchIndexes(Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        return Reactor.toMono(() -> this.async.watchIndexes(indexNames, timeout, options));
    }
}

