/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka;

import com.couchbase.client.core.env.AbstractMapPropertyLoader;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CertificateAuthenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.IoConfig;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.connect.kafka.config.common.CommonConfig;
import com.couchbase.connect.kafka.util.ScopeAndCollection;
import java.io.Closeable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import reactor.util.annotation.Nullable;

public class KafkaCouchbaseClient
implements Closeable {
    private final ClusterEnvironment env;
    private final Cluster cluster;
    private final Bucket bucket;

    public KafkaCouchbaseClient(CommonConfig config) {
        this(config, Collections.emptyMap());
    }

    public KafkaCouchbaseClient(CommonConfig config, Map<String, String> clusterEnvProps) {
        List<String> clusterAddress = config.seedNodes();
        String connectionString = String.join((CharSequence)",", clusterAddress);
        NetworkResolution networkResolution = NetworkResolution.valueOf((String)config.network());
        SecurityConfig.Builder securityConfig = SecurityConfig.builder().enableTls(config.enableTls()).enableHostnameVerification(config.enableHostnameVerification());
        if (!CbStrings.isNullOrEmpty((String)config.trustStorePath())) {
            securityConfig.trustStore(Paths.get(config.trustStorePath(), new String[0]), config.trustStorePassword().value(), Optional.empty());
        }
        if (!CbStrings.isNullOrEmpty((String)config.trustCertificatePath())) {
            securityConfig.trustCertificate(Paths.get(config.trustCertificatePath(), new String[0]));
        }
        ClusterEnvironment.Builder envBuilder = (ClusterEnvironment.Builder)((ClusterEnvironment.Builder)((ClusterEnvironment.Builder)ClusterEnvironment.builder().securityConfig(securityConfig)).ioConfig(IoConfig.networkResolution((NetworkResolution)networkResolution))).timeoutConfig(TimeoutConfig.connectTimeout((Duration)config.bootstrapTimeout()));
        KafkaCouchbaseClient.applyCustomEnvironmentProperties(envBuilder, clusterEnvProps);
        this.env = envBuilder.build();
        PasswordAuthenticator authenticator = CbStrings.isNullOrEmpty((String)config.clientCertificatePath()) ? PasswordAuthenticator.create((String)config.username(), (String)config.password().value()) : CertificateAuthenticator.fromKeyStore((Path)Paths.get(config.clientCertificatePath(), new String[0]), (String)config.clientCertificatePassword().value(), Optional.empty());
        this.cluster = Cluster.connect((String)connectionString, (ClusterOptions)ClusterOptions.clusterOptions((Authenticator)authenticator).environment(this.env));
        this.bucket = config.bucket().isEmpty() ? null : this.cluster.bucket(config.bucket());
    }

    private static void applyCustomEnvironmentProperties(ClusterEnvironment.Builder envBuilder, final Map<String, String> envProps) {
        try {
            envBuilder.load((PropertyLoader)new AbstractMapPropertyLoader<CoreEnvironment.Builder>(){

                protected Map<String, String> propertyMap() {
                    return envProps;
                }
            });
        }
        catch (Exception e) {
            throw new ConfigException("Failed to apply Couchbase environment properties; " + e.getMessage());
        }
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    @Nullable
    public Bucket bucket() {
        return this.bucket;
    }

    @Nullable
    public Collection collection(ScopeAndCollection scopeAndCollection) {
        if (this.bucket == null) {
            return null;
        }
        return Objects.requireNonNull(this.bucket()).scope(scopeAndCollection.getScope()).collection(scopeAndCollection.getCollection());
    }

    @Override
    public void close() {
        this.cluster.disconnect();
        this.env.shutdown();
    }
}

