/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.sink;

import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.connect.kafka.handler.sink.ConcurrencyHint;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerParams;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SinkAction {
    private static final SinkAction IGNORE = new SinkAction((Publisher<?>)Mono.empty(), ConcurrencyHint.alwaysConcurrent());
    private final Mono<Void> action;
    private final ConcurrencyHint concurrencyHint;

    public static SinkAction ignore() {
        return IGNORE;
    }

    public static SinkAction remove(SinkHandlerParams params, ReactiveCollection collection, String documentId) {
        RemoveOptions options = RemoveOptions.removeOptions();
        params.configureDurability((CommonDurabilityOptions<?>)options);
        Mono action = collection.remove(documentId, options).onErrorResume(DocumentNotFoundException.class, throwable -> Mono.empty());
        return new SinkAction((Publisher<?>)action, ConcurrencyHint.of(documentId));
    }

    public static SinkAction upsertJson(SinkHandlerParams params, ReactiveCollection collection, String documentId, byte[] json) {
        UpsertOptions options = UpsertOptions.upsertOptions().transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
        params.configureDurability((CommonDurabilityOptions<?>)options);
        params.expiry().ifPresent(arg_0 -> ((UpsertOptions)options).expiry(arg_0));
        Mono action = collection.upsert(documentId, (Object)json, options);
        return new SinkAction((Publisher<?>)action, ConcurrencyHint.of(documentId));
    }

    public SinkAction(Publisher<?> action, ConcurrencyHint concurrencyHint) {
        this.action = Mono.ignoreElements(action);
        this.concurrencyHint = Objects.requireNonNull(concurrencyHint);
    }

    public Mono<Void> action() {
        return this.action;
    }

    public ConcurrencyHint concurrencyHint() {
        return this.concurrencyHint;
    }
}

