/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.sink;

import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.ArrayAppend;
import com.couchbase.client.java.kv.ArrayPrepend;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.StoreSemantics;
import com.couchbase.client.java.kv.Upsert;
import com.couchbase.connect.kafka.config.sink.SubDocumentSinkHandlerConfig;
import com.couchbase.connect.kafka.handler.sink.ConcurrencyHint;
import com.couchbase.connect.kafka.handler.sink.N1qlSinkHandler;
import com.couchbase.connect.kafka.handler.sink.SinkAction;
import com.couchbase.connect.kafka.handler.sink.SinkDocument;
import com.couchbase.connect.kafka.handler.sink.SinkHandler;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerContext;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerParams;
import com.couchbase.connect.kafka.util.DocumentPathExtractor;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SubDocumentSinkHandler
implements SinkHandler {
    private static final Logger log = LoggerFactory.getLogger(SubDocumentSinkHandler.class);
    private SubDocumentSinkHandlerConfig.Operation mode;
    private String path;
    private boolean createPaths;
    private boolean pathIsDynamic;
    private boolean createDocuments;

    @Override
    public void init(SinkHandlerContext context) {
        Map<String, String> properties = N1qlSinkHandler.withAlias(context.configProperties(), ConfigHelper.keyName(SubDocumentSinkHandlerConfig.class, SubDocumentSinkHandlerConfig::subdocumentCreateDocument), "couchbase.create.document");
        SubDocumentSinkHandlerConfig config = ConfigHelper.parse(SubDocumentSinkHandlerConfig.class, properties);
        this.mode = config.subdocumentOperation();
        this.path = config.subdocumentPath();
        this.createPaths = config.subdocumentCreatePath();
        this.createDocuments = config.subdocumentCreateDocument();
        if (this.path.trim().isEmpty()) {
            String keyName = ConfigHelper.keyName(SubDocumentSinkHandlerConfig.class, SubDocumentSinkHandlerConfig::subdocumentPath);
            throw new ConfigException("Missing required configuration \"" + keyName + "\"");
        }
        if (this.path.startsWith("/")) {
            this.path = "${" + this.path + "}";
            this.pathIsDynamic = true;
        } else {
            this.pathIsDynamic = false;
        }
    }

    @Override
    public SinkAction handle(SinkHandlerParams params) {
        Upsert mutation;
        String documentId = this.getDocumentId(params);
        SinkDocument doc = params.document().orElse(null);
        if (doc == null) {
            return SinkAction.remove(params, params.collection(), documentId);
        }
        SubdocOperation operation = this.getOperation(documentId, doc);
        switch (this.mode) {
            case UPSERT: {
                mutation = MutateInSpec.upsert((String)operation.getPath(), (Object)operation.getData());
                if (!this.createPaths) break;
                mutation = mutation.createPath();
                break;
            }
            case ARRAY_APPEND: {
                mutation = MutateInSpec.arrayAppend((String)operation.getPath(), Collections.singletonList(operation.getData()));
                if (!this.createPaths) break;
                mutation = ((ArrayAppend)mutation).createPath();
                break;
            }
            case ARRAY_PREPEND: {
                mutation = MutateInSpec.arrayPrepend((String)operation.getPath(), Collections.singletonList(operation.getData()));
                if (!this.createPaths) break;
                mutation = ((ArrayPrepend)mutation).createPath();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported subdoc mode: " + (Object)((Object)this.mode));
            }
        }
        MutateInOptions options = MutateInOptions.mutateInOptions().storeSemantics(this.createDocuments ? StoreSemantics.UPSERT : StoreSemantics.REPLACE);
        params.expiry().ifPresent(arg_0 -> ((MutateInOptions)options).expiry(arg_0));
        params.configureDurability((CommonDurabilityOptions<?>)options);
        Mono action = params.collection().mutateIn(documentId, Collections.singletonList(mutation), options);
        return new SinkAction((Publisher<?>)action, ConcurrencyHint.of(documentId));
    }

    private SubdocOperation getOperation(String documentId, SinkDocument doc) {
        if (!this.pathIsDynamic) {
            return new SubdocOperation(documentId, this.path, doc.content());
        }
        try {
            DocumentPathExtractor extractor = new DocumentPathExtractor(this.path, true);
            DocumentPathExtractor.DocumentExtraction extraction = extractor.extractDocumentPath(doc.content());
            return new SubdocOperation(documentId, extraction.getPathValue(), extraction.getData());
        }
        catch (DocumentPathExtractor.DocumentPathNotFoundException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new SubdocOperation(documentId, null, null);
        }
    }

    public String toString() {
        return "SubDocumentSinkHandler{mode=" + (Object)((Object)this.mode) + ", path='" + this.path + '\'' + ", createPaths=" + this.createPaths + ", pathIsDynamic=" + this.pathIsDynamic + ", createDocuments=" + this.createDocuments + '}';
    }

    private static class SubdocOperation {
        private final String id;
        private final String path;
        private final JsonObject data;

        public SubdocOperation(String id, String path, byte[] data) {
            this.id = id;
            this.path = path;
            this.data = JsonObject.fromJson((byte[])data);
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public JsonObject getData() {
            return this.data;
        }
    }
}

