/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.dcp.highlevel.DocumentChange;
import com.couchbase.connect.kafka.handler.source.CouchbaseSourceRecord;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;

public class SourceRecordBuilder {
    private String topic;
    private Integer kafkaPartition;
    private Schema keySchema;
    private Object key;
    private Schema valueSchema;
    private Object value;
    private Long timestamp;
    private final Headers headers = new ConnectHeaders();

    public SourceRecordBuilder key(Schema keySchema, Object key) {
        this.keySchema = keySchema;
        this.key = key;
        return this;
    }

    public SourceRecordBuilder key(String key) {
        return this.key(Schema.STRING_SCHEMA, key);
    }

    public SourceRecordBuilder value(Schema valueSchema, Object value) {
        this.valueSchema = valueSchema;
        this.value = value;
        return this;
    }

    public SourceRecordBuilder value(String value) {
        return this.value(Schema.STRING_SCHEMA, value);
    }

    public SourceRecordBuilder topic(String topic) {
        this.topic = topic;
        return this;
    }

    public SourceRecordBuilder kafkaPartition(Integer kafkaPartition) {
        this.kafkaPartition = kafkaPartition;
        return this;
    }

    public SourceRecordBuilder timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Headers headers() {
        return this.headers;
    }

    @Stability.Internal
    public CouchbaseSourceRecord build(DocumentChange change, Map<String, ?> sourcePartition, Map<String, ?> sourceOffset, String defaultTopic) {
        return new CouchbaseSourceRecord(change, sourcePartition, sourceOffset, (String)CbObjects.defaultIfNull((Object)this.topic, (Object)defaultTopic), this.kafkaPartition, this.keySchema, this.key, this.valueSchema, this.value, this.timestamp, (Iterable<Header>)this.headers);
    }
}

