/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import com.couchbase.client.core.util.CbStrings;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxHelper.class);

    private JmxHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static JmxMeterRegistry newJmxMeterRegistry(String domain, LinkedHashMap<String, String> commonKeyProperties) {
        MetricRegistry registry = new MetricRegistry();
        String namePrefix = domain + ":" + JmxHelper.format(commonKeyProperties);
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)registry).createsObjectNamesWith(JmxHelper.preformattedObjectNameFactory(namePrefix)).build();
        return new JmxMeterRegistry(JmxConfig.DEFAULT, Clock.SYSTEM, JmxHelper.jmxNameMapper("dcp"), registry, reporter);
    }

    private static HierarchicalNameMapper jmxNameMapper(String ... groups) {
        return (id, convention) -> {
            String canonicalName = id.getType().name().toLowerCase(Locale.ROOT).replace("_", ".");
            String type = convention.name(canonicalName, id.getType());
            LinkedHashMap<String, String> keyProperties = new LinkedHashMap<String, String>();
            keyProperties.put("type", type);
            String name = id.getName();
            for (String group : groups) {
                String prefix = group + ".";
                if (!id.getName().startsWith(prefix)) continue;
                name = CbStrings.removeStart((String)name, (String)prefix);
                keyProperties.put("group", group);
                break;
            }
            keyProperties.put("name", convention.name(name, id.getType()));
            LinkedHashMap<String, String> orderedTags = JmxHelper.toMapWithOrderedKeys(id.getTagsAsIterable(), "remote", "opcode", "result", "exception");
            if ("success".equals(orderedTags.get("result"))) {
                orderedTags.remove("exception");
            }
            for (Map.Entry<String, String> tag : orderedTags.entrySet()) {
                keyProperties.put(convention.name(tag.getKey(), id.getType()), ObjectName.quote(tag.getValue()));
            }
            return JmxHelper.format(keyProperties);
        };
    }

    private static String format(Map<String, String> keyProperties) {
        return keyProperties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
    }

    private static LinkedHashMap<String, String> toMapWithOrderedKeys(Iterable<Tag> tags, String ... orderedKeys) {
        LinkedHashMap<String, String> tagMap = new LinkedHashMap<String, String>();
        for (Tag tag : tags) {
            tagMap.put(tag.getKey(), tag.getValue());
        }
        return JmxHelper.withKeysInOrder(tagMap, orderedKeys);
    }

    @SafeVarargs
    private static <K, V> LinkedHashMap<K, V> withKeysInOrder(Map<K, V> map, K ... orderedKeys) {
        LinkedHashMap<K, V> temp = new LinkedHashMap<K, V>(map);
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (K key : orderedKeys) {
            Object value = temp.remove(key);
            if (value == null) continue;
            result.put(key, value);
        }
        result.putAll(temp);
        return result;
    }

    private static ObjectNameFactory preformattedObjectNameFactory(String objectNamePrefix) {
        return (type, domain, name) -> {
            try {
                return ObjectName.getInstance(objectNamePrefix + "," + name);
            }
            catch (MalformedObjectNameException e) {
                LOGGER.error("failed to create ObjectName for metric '{}'", (Object)name);
                throw new RuntimeException(e);
            }
        };
    }
}

