/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.sink;

import com.couchbase.connect.kafka.handler.sink.SinkAction;
import com.couchbase.connect.kafka.handler.sink.SinkDocument;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerContext;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerParams;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.connect.sink.SinkRecord;

public interface SinkHandler {
    default public void init(SinkHandlerContext context) {
    }

    public SinkAction handle(SinkHandlerParams var1);

    default public String getDocumentId(SinkHandlerParams params) {
        return params.document().flatMap(SinkDocument::id).orElseGet(() -> this.getDocumentIdFromKafkaMetadata(params.sinkRecord()));
    }

    default public String getDocumentIdFromKafkaMetadata(SinkRecord record) {
        Object key = record.key();
        if (key instanceof String || key instanceof Number || key instanceof Boolean) {
            return key.toString();
        }
        if (key instanceof byte[]) {
            return new String((byte[])key, StandardCharsets.UTF_8);
        }
        if (key instanceof ByteBuffer) {
            return StandardCharsets.UTF_8.decode((ByteBuffer)key).toString();
        }
        return record.topic() + "/" + record.kafkaPartition() + "/" + record.kafkaOffset();
    }
}

