/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.dcp.core.CouchbaseException;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.java.Bucket;
import com.couchbase.connect.kafka.util.CouchbaseHelper;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SeedNodeHelper {
    private SeedNodeHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Set<SeedNode> getKvNodes(Bucket bucket, ConnectionString connectionString, boolean tls, NetworkResolution networkResolution, Duration timeout) {
        BucketConfig config = CouchbaseHelper.getConfig(bucket, timeout);
        if (networkResolution.equals((Object)NetworkResolution.AUTO)) {
            EventBus eventBus = bucket.environment().eventBus();
            Set<String> seedHosts = ConnectionStringUtil.seedNodesFromConnectionString((ConnectionString)connectionString, (boolean)true, (boolean)tls, (EventBus)eventBus).stream().map(SeedNode::address).collect(Collectors.toSet());
            networkResolution = SeedNodeHelper.inferNetwork(config, networkResolution, seedHosts);
        }
        NetworkResolution finalNetworkResolution = networkResolution;
        return config.nodes().stream().map(node -> new ResolvedNodeInfo((NodeInfo)node, tls, finalNetworkResolution)).map(node -> SeedNode.create((String)node.host(), node.port(ServiceType.KV), node.port(ServiceType.MANAGER))).filter(node -> node.kvPort().isPresent()).collect(Collectors.toSet());
    }

    private static Map<ServiceType, Integer> services(NodeInfo node, boolean secure) {
        return secure ? node.sslServices() : node.services();
    }

    private static Map<ServiceType, Integer> services(AlternateAddress node, boolean secure) {
        return secure ? node.sslServices() : node.services();
    }

    private static NetworkResolution inferNetwork(BucketConfig config, NetworkResolution network, Set<String> seedHosts) {
        if (!network.equals((Object)NetworkResolution.AUTO)) {
            return network;
        }
        for (NodeInfo info : config.nodes()) {
            if (seedHosts.contains(info.hostname())) {
                return NetworkResolution.DEFAULT;
            }
            Map aa = info.alternateAddresses();
            if (aa == null || aa.isEmpty()) continue;
            for (Map.Entry entry : aa.entrySet()) {
                AlternateAddress alternateAddress = (AlternateAddress)entry.getValue();
                if (alternateAddress == null || !seedHosts.contains(alternateAddress.hostname())) continue;
                return NetworkResolution.valueOf((String)((String)entry.getKey()));
            }
        }
        return NetworkResolution.DEFAULT;
    }

    private static class ResolvedNodeInfo {
        private final String host;
        private final Map<ServiceType, Integer> services;

        public ResolvedNodeInfo(NodeInfo unresolved, boolean tls, NetworkResolution networkResolution) {
            if (networkResolution.equals((Object)NetworkResolution.AUTO)) {
                throw new IllegalArgumentException("Must resolve 'auto' network first");
            }
            if (networkResolution.equals((Object)NetworkResolution.DEFAULT)) {
                this.host = unresolved.hostname();
                this.services = Collections.unmodifiableMap(new HashMap(SeedNodeHelper.services(unresolved, tls)));
            } else {
                AlternateAddress alternate = (AlternateAddress)unresolved.alternateAddresses().get(networkResolution.name());
                if (alternate == null) {
                    throw new CouchbaseException("Node " + RedactableArgument.system((Object)unresolved.hostname()) + " has no alternate hostname for network [" + networkResolution + "]");
                }
                this.host = alternate.hostname();
                HashMap tempServices = new HashMap(SeedNodeHelper.services(unresolved, tls));
                tempServices.putAll(SeedNodeHelper.services(alternate, tls));
                this.services = Collections.unmodifiableMap(tempServices);
            }
        }

        public String host() {
            return this.host;
        }

        public Optional<Integer> port(ServiceType serviceType) {
            return Optional.ofNullable(this.services.get(serviceType));
        }
    }
}

