/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.config.sink;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.connect.kafka.handler.sink.SinkHandler;
import com.couchbase.connect.kafka.util.ScopeAndCollection;
import com.couchbase.connect.kafka.util.TopicMap;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import com.couchbase.connect.kafka.util.config.annotation.Default;
import java.time.Duration;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;

public interface SinkBehaviorConfig {
    @Default(value="_default._default")
    public String defaultCollection();

    public static ConfigDef.Validator defaultCollectionValidator() {
        return ConfigHelper.validate(ScopeAndCollection::parse, "A collection name qualified by a scope name (scope.collection)");
    }

    @Default
    public List<String> topicToCollection();

    public static ConfigDef.Validator topicToCollectionValidator() {
        return ConfigHelper.validate(TopicMap::parseTopicToCollection, "topic=scope.collection,...");
    }

    @Default(value="com.couchbase.connect.kafka.handler.sink.UpsertSinkHandler")
    public Class<? extends SinkHandler> sinkHandler();

    @Default(value="DOCUMENT")
    @Deprecated
    public DocumentMode documentMode();

    @Default
    public String documentId();

    @Default(value="false")
    public boolean removeDocumentId();

    @Default(value="0")
    public Duration documentExpiration();

    @Default(value="0")
    @Stability.Uncommitted
    public Duration retryTimeout();

    @Deprecated
    public static enum DocumentMode {
        DOCUMENT,
        SUBDOCUMENT,
        N1QL;

    }
}

