/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.connect.kafka.handler.sink.ConcurrencyHint;
import com.couchbase.connect.kafka.util.N1qlData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AnalyticsBatchBuilder {
    private final List<Batch> batches = new ArrayList<Batch>();
    private final int maxBatchSize;

    public AnalyticsBatchBuilder(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public void add(N1qlData data) {
        ConcurrencyHint hint = data.getHint();
        String keyspace = data.getKeyspace();
        N1qlData.OperationType type = data.getType();
        Batch batch = this.getBatch(keyspace, hint, type);
        batch.add(data);
    }

    private Batch getBatch(String keyspace, ConcurrencyHint hint, N1qlData.OperationType type) {
        Batch currentBatch;
        if (!this.batches.isEmpty() && (currentBatch = this.batches.get(this.batches.size() - 1)).isCompatible(keyspace, type, hint)) {
            return currentBatch;
        }
        Batch batch = new Batch(keyspace, type, this.batches.size(), this.maxBatchSize);
        this.batches.add(batch);
        return batch;
    }

    public List<String> build() {
        return this.batches.stream().map(Batch::getBlockQuery).collect(Collectors.toList());
    }

    private static class Batch {
        private final N1qlData.OperationType type;
        private final String keyspace;
        private final Set<ConcurrencyHint> hints = new HashSet<ConcurrencyHint>();
        private final StringBuilder batchedData = new StringBuilder();
        private final int batchId;
        private final int batchLimit;
        private int countOfRecordsInCurrentBatch = 0;

        Batch(String keyspace, N1qlData.OperationType type, int batchId, int batchLimit) {
            this.type = type;
            this.keyspace = keyspace;
            this.batchId = batchId;
            this.batchLimit = batchLimit;
        }

        public N1qlData.OperationType getType() {
            return this.type;
        }

        void add(N1qlData data) {
            this.hints.add(data.getHint());
            switch (data.getType()) {
                case UPSERT: {
                    if (this.batchedData.length() != 0) {
                        this.batchedData.append(" , ");
                    }
                    this.batchedData.append(data.getData());
                    ++this.countOfRecordsInCurrentBatch;
                    break;
                }
                case DELETE: {
                    if (this.batchedData.length() != 0) {
                        this.batchedData.append(" OR ");
                    }
                    this.batchedData.append(data.getData());
                    ++this.countOfRecordsInCurrentBatch;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No Type " + (Object)((Object)data.getType()) + " Found");
                }
            }
        }

        public int getCountOfRecordsInCurrentBatch() {
            return this.countOfRecordsInCurrentBatch;
        }

        public boolean isCompatible(String keyspace, N1qlData.OperationType type, ConcurrencyHint hint) {
            return this.keyspace.equals(keyspace) && this.type.equals((Object)type) && !this.hints.contains(hint) && this.getCountOfRecordsInCurrentBatch() < this.batchLimit;
        }

        public String getBlockQuery() {
            String queryFromBatchedData;
            switch (this.type) {
                case UPSERT: {
                    queryFromBatchedData = "UPSERT INTO " + this.keyspace + " ([" + this.batchedData + "])";
                    break;
                }
                case DELETE: {
                    queryFromBatchedData = "DELETE FROM " + this.keyspace + " WHERE " + this.batchedData;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No Type " + (Object)((Object)this.type) + " Found");
                }
            }
            return queryFromBatchedData;
        }

        public int getBatchId() {
            return this.batchId;
        }
    }
}

