/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.config.sink;

import com.couchbase.connect.kafka.handler.sink.SinkHandler;
import com.couchbase.connect.kafka.util.Keyspace;
import com.couchbase.connect.kafka.util.TopicMap;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import com.couchbase.connect.kafka.util.config.annotation.Default;
import java.time.Duration;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;

public interface SinkBehaviorConfig {
    @Default(value="_default._default")
    public String defaultCollection();

    public static ConfigDef.Validator defaultCollectionValidator() {
        return ConfigHelper.validate(value -> Keyspace.parse(value, null), "A qualified collection name like 'scope.collection' or 'bucket.scope.collection'. If the bucket component contains a dot, escape it by enclosing it in backticks.");
    }

    @Default
    public List<String> topicToCollection();

    public static ConfigDef.Validator topicToCollectionValidator() {
        return ConfigHelper.validate(value -> TopicMap.parseTopicToCollection(value, null), "topic1=scope.collection,topic2=other-bucket.scope.collection,... If a bucket component contains a dot, escape it by enclosing it in backticks.");
    }

    @Default(value="com.couchbase.connect.kafka.handler.sink.UpsertSinkHandler")
    public Class<? extends SinkHandler> sinkHandler();

    @Default(value="DOCUMENT")
    @Deprecated
    public DocumentMode documentMode();

    @Default
    public String documentId();

    @Default(value="false")
    public boolean removeDocumentId();

    @Default(value="0")
    public Duration documentExpiration();

    @Default(value="0")
    public Duration retryTimeout();

    @Deprecated
    public static enum DocumentMode {
        DOCUMENT,
        SUBDOCUMENT,
        N1QL;

    }
}

