/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.java.Bucket;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class CouchbaseHelper {
    public static Mono<BucketConfig> getConfig(Core core, String bucketName) {
        return core.configurationProvider().configs().flatMap(clusterConfig -> Mono.justOrEmpty((Object)clusterConfig.bucketConfig(bucketName))).filter(CouchbaseHelper::hasPartitionInfo).next();
    }

    private static boolean hasPartitionInfo(BucketConfig config) {
        return ((CouchbaseBucketConfig)config).numberOfPartitions() > 0;
    }

    public static Mono<BucketConfig> getConfig(Bucket bucket) {
        return CouchbaseHelper.getConfig(bucket.core(), bucket.name());
    }

    public static BucketConfig getConfig(Bucket bucket, Duration timeout) {
        return (BucketConfig)CouchbaseHelper.getConfig(bucket).block(timeout);
    }
}

