/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka;

import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.dcp.metrics.LogLevel;
import com.couchbase.client.dcp.util.PartitionSet;
import com.couchbase.connect.kafka.SourceOffset;
import com.couchbase.connect.kafka.util.ConnectHelper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceTaskLifecycle {
    private final LogLevel logLevel = LogLevel.INFO;
    private static final Logger log = LoggerFactory.getLogger(SourceTaskLifecycle.class);
    private final String uuid = UUID.randomUUID().toString();

    public void logTaskInitialized(String connectorName) {
        this.logMilestone(Milestone.TASK_INITIALIZED, CbCollections.mapOf((Object)"connectorName", (Object)connectorName));
    }

    public void logOffsetCommitHook() {
        this.logMilestone(Milestone.OFFSET_COMMIT_HOOK, Collections.emptyMap());
    }

    public void logTaskStarted(String name, PartitionSet partitions) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("connectorName", name);
        details.put("assignedPartitions", partitions.format());
        this.logMilestone(Milestone.TASK_STARTED, details);
    }

    public void logSourceOffsetsRead(Map<Integer, SourceOffset> sourceOffsets, PartitionSet partitionsWithoutSavedOffsets) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("partitionsWithNoSavedOffset", partitionsWithoutSavedOffsets.format());
        details.put("sourceOffsets", new TreeMap<Integer, SourceOffset>(sourceOffsets));
        this.logMilestone(Milestone.SOURCE_OFFSETS_READ, details);
    }

    public void logTaskStopped() {
        this.logMilestone(Milestone.TASK_STOPPED, Collections.emptyMap());
    }

    private void logMilestone(Milestone milestone, Map<String, Object> milestoneDetails) {
        if (this.enabled()) {
            LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
            message.put("milestone", (Object)milestone);
            message.put("taskUuid", this.uuid);
            ConnectHelper.getConnectorContextFromLoggingContext().ifPresent(it -> message.put("context", it));
            message.putAll(milestoneDetails);
            this.doLog(message);
        }
    }

    private void doLog(Object message) {
        try {
            this.logLevel.log(log, Mapper.encodeAsString((Object)message));
        }
        catch (Exception e) {
            this.logLevel.log(log, message.toString());
        }
    }

    private boolean enabled() {
        return true;
    }

    public static enum Milestone {
        TASK_INITIALIZED,
        TASK_STARTED,
        TASK_STOPPED,
        SOURCE_OFFSETS_READ,
        OFFSET_COMMIT_HOOK;

    }
}

