/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonFactory;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonParser;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonPointer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.filter.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentPathExtractor {
    private static final JsonFactory factory = new JsonFactory();
    private final String documentPathFormat;
    private final Map<String, JsonPointer> placeholderToJsonPointer;
    private final boolean removeDocumentPath;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(.+?)}");

    public DocumentPathExtractor(String documentPathFormat, boolean removeDocumentPath) {
        if (documentPathFormat.isEmpty()) {
            throw new IllegalArgumentException("Document ID format must not be empty");
        }
        Matcher m = PLACEHOLDER_PATTERN.matcher(documentPathFormat);
        if (!m.find() && !(m = PLACEHOLDER_PATTERN.matcher(documentPathFormat = "${" + documentPathFormat + "}")).find()) {
            throw new AssertionError((Object)"invalid document ID format string");
        }
        HashMap<String, JsonPointer> placeholderToJsonPointerTemp = new HashMap<String, JsonPointer>();
        do {
            String placeholder = m.group();
            String jsonPointer = m.group(1);
            placeholderToJsonPointerTemp.put(placeholder, JsonPointer.compile((String)jsonPointer));
        } while (m.find());
        this.placeholderToJsonPointer = Collections.unmodifiableMap(placeholderToJsonPointerTemp);
        this.documentPathFormat = documentPathFormat;
        this.removeDocumentPath = removeDocumentPath;
    }

    public DocumentExtraction extractDocumentPath(byte[] json) throws IOException, DocumentPathNotFoundException {
        ArrayList<ByteRange> rangesToRemove = new ArrayList<ByteRange>(this.placeholderToJsonPointer.size());
        String documentId = this.documentPathFormat;
        for (Map.Entry<String, JsonPointer> idComponent : this.placeholderToJsonPointer.entrySet()) {
            String placeholder = idComponent.getKey();
            JsonPointer documentIdPointer = idComponent.getValue();
            FilteringParserDelegate parser = new FilteringParserDelegate(factory.createParser(json), (TokenFilter)new JsonPointerBasedFilter(documentIdPointer), TokenFilter.Inclusion.ONLY_INCLUDE_ALL, false);
            if (parser.nextToken() == null) {
                throw new DocumentPathNotFoundException("Document has no value matching JSON pointer '" + documentIdPointer + "'");
            }
            String component = parser.getValueAsString();
            if (component == null) {
                throw new DocumentPathNotFoundException("The value matching JSON pointer '" + documentIdPointer + "' is null or non-scalar.");
            }
            documentId = documentId.replace(placeholder, component);
            if (!this.removeDocumentPath) continue;
            rangesToRemove.add(ByteRange.forCurrentToken(json, (JsonParser)parser));
        }
        for (ByteRange range : rangesToRemove) {
            DocumentPathExtractor.swallowFieldName(range);
            DocumentPathExtractor.swallowOneComma(range);
            range.fill(json, (byte)32);
        }
        return new DocumentExtraction(documentId, json);
    }

    private static void swallowOneComma(ByteRange range) {
        DocumentPathExtractor.swallowWhitespace(range);
        if (range.bytes[range.pastEndOffset] == 44) {
            range.pastEndOffset++;
        } else if (range.bytes[range.startOffset - 1] == 44) {
            range.startOffset--;
        }
    }

    private static void swallowWhitespace(ByteRange range) {
        DocumentPathExtractor.swallowWhitespaceLeft(range);
        DocumentPathExtractor.swallowWhitespaceRight(range);
    }

    private static void swallowWhitespaceLeft(ByteRange range) {
        while (DocumentPathExtractor.isJsonWhitespace(range.bytes[range.startOffset - 1])) {
            range.startOffset--;
        }
    }

    private static void swallowWhitespaceRight(ByteRange range) {
        while (DocumentPathExtractor.isJsonWhitespace(range.bytes[range.pastEndOffset])) {
            range.pastEndOffset++;
        }
    }

    private static void swallowFieldName(ByteRange range) {
        DocumentPathExtractor.swallowWhitespaceLeft(range);
        byte prevChar = range.bytes[range.startOffset - 1];
        if (prevChar == 58) {
            range.startOffset--;
            DocumentPathExtractor.swallowWhitespaceLeft(range);
            range.startOffset--;
            do {
                range.startOffset--;
            } while (range.bytes[range.startOffset] != 34 || range.bytes[range.startOffset - 1] == 92);
        }
    }

    private static boolean isJsonWhitespace(byte b) {
        switch (b) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static class DocumentPathNotFoundException
    extends Exception {
        DocumentPathNotFoundException(String message) {
            super(message);
        }
    }

    private static class ByteRange {
        private final byte[] bytes;
        private int startOffset;
        private int pastEndOffset;

        private ByteRange(byte[] bytes, int startOffset, int pastEndOffset) {
            this.bytes = bytes;
            this.startOffset = startOffset;
            this.pastEndOffset = pastEndOffset;
        }

        private static ByteRange forCurrentToken(byte[] bytes, JsonParser parser) {
            return new ByteRange(bytes, (int)parser.getTokenLocation().getByteOffset(), (int)parser.getCurrentLocation().getByteOffset());
        }

        public String toString() {
            return "[" + this.startOffset + "," + this.pastEndOffset + ") = |" + new String(this.bytes, this.startOffset, this.pastEndOffset - this.startOffset) + "|";
        }

        void fill(byte[] bytes, byte fillByte) {
            Arrays.fill(bytes, this.startOffset, this.pastEndOffset, fillByte);
        }
    }

    public static class DocumentExtraction {
        private final String pathValue;
        private final byte[] data;

        DocumentExtraction(String pathValue, byte[] data) {
            this.pathValue = pathValue;
            this.data = Objects.requireNonNull(data);
        }

        public String getPathValue() {
            return this.pathValue;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

