/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.connect.kafka.util.Keyspace;
import java.util.Objects;

public class ScopeAndCollection {
    private final String scope;
    private final String collection;

    public static ScopeAndCollection parse(String scopeAndCollection) {
        try {
            Keyspace ks = Keyspace.parse(scopeAndCollection, null);
            if (ks.getBucket() != null) {
                throw new IllegalArgumentException("Expected 2 components, but got 3; a bucket name is not valid in this context.");
            }
            return new ScopeAndCollection(ks.getScope(), ks.getCollection());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected a qualified collection name (scope.collection) with no bucket component, but got: " + scopeAndCollection, e);
        }
    }

    public ScopeAndCollection(String scope, String collection) {
        this.scope = Objects.requireNonNull(scope);
        this.collection = Objects.requireNonNull(collection);
    }

    public String getScope() {
        return this.scope;
    }

    public String getCollection() {
        return this.collection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeAndCollection that = (ScopeAndCollection)o;
        return this.scope.equals(that.scope) && this.collection.equals(that.collection);
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.collection);
    }
}

