/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka;

import com.couchbase.client.core.env.AbstractMapPropertyLoader;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CertificateAuthenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.connect.kafka.config.common.CommonConfig;
import com.couchbase.connect.kafka.util.Keyspace;
import java.io.Closeable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import reactor.util.annotation.Nullable;

public class KafkaCouchbaseClient
implements Closeable {
    private final Cluster cluster;
    private final Bucket bucket;

    public KafkaCouchbaseClient(CommonConfig config) {
        this(config, Collections.emptyMap());
    }

    public KafkaCouchbaseClient(CommonConfig config, Map<String, String> clusterEnvProps) {
        List<String> clusterAddress = config.seedNodes();
        String connectionString = String.join((CharSequence)",", clusterAddress);
        NetworkResolution networkResolution = NetworkResolution.valueOf((String)config.network());
        PasswordAuthenticator authenticator = CbStrings.isNullOrEmpty((String)config.clientCertificatePath()) ? PasswordAuthenticator.create((String)config.username(), (String)config.password().value()) : CertificateAuthenticator.fromKeyStore((Path)Paths.get(config.clientCertificatePath(), new String[0]), (String)config.clientCertificatePassword().value(), Optional.empty());
        Cluster.maxAllowedInstances((int)Integer.MAX_VALUE);
        this.cluster = Cluster.connect((String)connectionString, (ClusterOptions)ClusterOptions.clusterOptions((Authenticator)authenticator).environment(env -> {
            ((ClusterEnvironment.Builder)((ClusterEnvironment.Builder)env.securityConfig(security -> KafkaCouchbaseClient.configureSecurity(security, config))).ioConfig(io -> io.networkResolution(networkResolution))).timeoutConfig(timeout -> timeout.connectTimeout(config.bootstrapTimeout()));
            KafkaCouchbaseClient.applyCustomEnvironmentProperties(env, clusterEnvProps);
        }));
        this.bucket = config.bucket().isEmpty() ? null : this.cluster.bucket(config.bucket());
    }

    private static void configureSecurity(SecurityConfig.Builder security, CommonConfig config) {
        security.enableTls(config.enableTls()).enableHostnameVerification(config.enableHostnameVerification());
        if (!CbStrings.isNullOrEmpty((String)config.trustStorePath())) {
            security.trustStore(Paths.get(config.trustStorePath(), new String[0]), config.trustStorePassword().value(), Optional.empty());
        }
        if (!CbStrings.isNullOrEmpty((String)config.trustCertificatePath())) {
            security.trustCertificate(Paths.get(config.trustCertificatePath(), new String[0]));
        }
    }

    private static void applyCustomEnvironmentProperties(ClusterEnvironment.Builder envBuilder, final Map<String, String> envProps) {
        try {
            envBuilder.load((PropertyLoader)new AbstractMapPropertyLoader<CoreEnvironment.Builder>(){

                protected Map<String, String> propertyMap() {
                    return envProps;
                }
            });
        }
        catch (Exception e) {
            throw new ConfigException("Failed to apply Couchbase environment properties; " + e.getMessage());
        }
    }

    public ClusterEnvironment env() {
        return this.cluster.environment();
    }

    public Cluster cluster() {
        return this.cluster;
    }

    @Nullable
    public Bucket bucket() {
        return this.bucket;
    }

    public Collection collection(Keyspace keyspace) {
        if (keyspace.getBucket() == null) {
            throw new IllegalArgumentException("Keyspace has null bucket/database. This is a bug. It probably means the sink handler's usesKvConnections() method returned false, but the connector tried to open a KV connection anyway.");
        }
        return this.cluster.bucket(keyspace.getBucket()).scope(keyspace.getScope()).collection(keyspace.getCollection());
    }

    @Override
    public void close() {
        this.cluster.disconnect();
    }
}

