/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka;

import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.dcp.metrics.LogLevel;
import com.couchbase.client.dcp.util.PartitionSet;
import com.couchbase.connect.kafka.SourceOffset;
import com.couchbase.connect.kafka.util.ConnectHelper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceTaskLifecycle {
    private static final Logger log = LoggerFactory.getLogger(SourceTaskLifecycle.class);
    private final String uuid = UUID.randomUUID().toString();

    public String taskUuid() {
        return this.uuid;
    }

    public void logTaskInitialized(String connectorName) {
        this.logMilestone(Milestone.TASK_INITIALIZED, CbCollections.mapOf((Object)"connectorName", (Object)connectorName));
    }

    public void logOffsetCommitHook() {
        this.logMilestone(Milestone.OFFSET_COMMIT_HOOK, Collections.emptyMap());
    }

    public void logTaskStarted(String name, PartitionSet partitions) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("connectorName", name);
        details.put("assignedPartitions", partitions.format());
        this.logMilestone(Milestone.TASK_STARTED, details);
    }

    public void logSourceOffsetsRead(Map<Integer, SourceOffset> sourceOffsets, PartitionSet partitionsWithoutSavedOffsets) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("partitionsWithNoSavedOffset", partitionsWithoutSavedOffsets.format());
        details.put("sourceOffsets", new TreeMap(CbCollections.transformValues(sourceOffsets, SourceOffset::toString)));
        this.logMilestone(Milestone.SOURCE_OFFSETS_READ, details);
    }

    public void logMissingSourceOffsetsSetToNow(PartitionSet partitionsSetToNow) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("partitionsSetToNow", partitionsSetToNow.format());
        this.logMilestone(Milestone.MISSING_SOURCE_OFFSETS_SET_TO_NOW, details);
    }

    public void logTaskStopped() {
        this.logMilestone(Milestone.TASK_STOPPED, Collections.emptyMap());
    }

    public void logTaskCleanupComplete() {
        this.logMilestone(Milestone.TASK_CLEANUP_COMPLETE, Collections.emptyMap());
    }

    private void logMilestone(Milestone milestone, Map<String, Object> milestoneDetails) {
        if (this.enabled()) {
            LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
            message.put("milestone", (Object)milestone);
            message.put("taskUuid", this.uuid);
            ConnectHelper.getConnectorContextFromLoggingContext().ifPresent(it -> message.put("context", it));
            message.putAll(milestoneDetails);
            this.doLog(milestone.logLevel, message);
        }
    }

    private void doLog(LogLevel level, Object message) {
        try {
            level.log(log, "{}", (Object)Mapper.encodeAsString((Object)message));
        }
        catch (Exception e) {
            level.log(log, "{}", message);
        }
    }

    private boolean enabled() {
        return true;
    }

    public static enum Milestone {
        TASK_INITIALIZED,
        TASK_STARTED,
        TASK_STOPPED,
        TASK_CLEANUP_COMPLETE,
        SOURCE_OFFSETS_READ,
        MISSING_SOURCE_OFFSETS_SET_TO_NOW,
        OFFSET_COMMIT_HOOK(LogLevel.DEBUG);

        private final LogLevel logLevel;

        private Milestone() {
            this(LogLevel.INFO);
        }

        private Milestone(LogLevel logLevel) {
            this.logLevel = Objects.requireNonNull(logLevel);
        }
    }
}

