/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.connect.kafka.util.DocumentIdExtractor;
import com.couchbase.connect.kafka.util.Keyspace;
import com.couchbase.connect.kafka.util.ScopeAndCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class TopicMap {
    private TopicMap() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Map<String, DocumentIdExtractor> parseTopicToDocumentId(List<String> topicToDocumentIdFormat, boolean removeDocumentId) {
        return TopicMap.mapValues(TopicMap.parseCommon(topicToDocumentIdFormat), docIdFormat -> new DocumentIdExtractor((String)docIdFormat, removeDocumentId));
    }

    public static Map<String, Keyspace> parseTopicToCollection(List<String> topicToCollection, @Nullable String defaultBucket) {
        return TopicMap.mapValues(TopicMap.parseCommon(topicToCollection), it -> Keyspace.parse(it, defaultBucket));
    }

    public static Map<ScopeAndCollection, String> parseCollectionToTopic(List<String> collectionToTopic) {
        return TopicMap.mapKeys(TopicMap.parseCommon(collectionToTopic), ScopeAndCollection::parse);
    }

    private static Map<String, String> parseCommon(List<String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entry : map) {
            String[] components = entry.split("=", -1);
            if (components.length != 2) {
                throw new IllegalArgumentException("Bad entry: '" + entry + "'. Expected exactly one equals (=) character separating key and value.");
            }
            result.put(components[0], components[1]);
        }
        return result;
    }

    private static <K, V1, V2> Map<K, V2> mapValues(Map<K, V1> map, Function<? super V1, ? extends V2> valueTransformer) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> valueTransformer.apply((Object)entry.getValue())));
    }

    private static <K1, K2, V> Map<K2, V> mapKeys(Map<K1, V> map, Function<? super K1, ? extends K2> keyTransformer) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> keyTransformer.apply((Object)entry.getKey()), Map.Entry::getValue));
    }
}

