/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.connect.kafka.handler.source.DocumentEvent;
import com.couchbase.connect.kafka.handler.source.MutationMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.header.Headers;

@Stability.Internal
public final class CouchbaseHeaderSetter {
    private static final Map<String, Function<DocumentEvent, SchemaAndValue>> template;
    private final Map<String, Function<DocumentEvent, SchemaAndValue>> headerNameToValueAccessor;

    public static Set<String> validHeaders() {
        return template.keySet();
    }

    public CouchbaseHeaderSetter(String prefix, Collection<String> headerNames) {
        LinkedHashSet<String> invalidHeaderNames = new LinkedHashSet<String>(headerNames);
        invalidHeaderNames.removeAll(CouchbaseHeaderSetter.validHeaders());
        if (!invalidHeaderNames.isEmpty()) {
            throw new IllegalArgumentException("Invalid header names: " + invalidHeaderNames + " ; each header name must be one of " + CouchbaseHeaderSetter.validHeaders());
        }
        LinkedHashMap map = new LinkedHashMap();
        headerNames.forEach(name -> map.put(prefix + name, template.get(name)));
        this.headerNameToValueAccessor = Collections.unmodifiableMap(map);
    }

    public void setHeaders(Headers headers, DocumentEvent event) {
        this.headerNameToValueAccessor.forEach((name, accessor) -> headers.add(name, (SchemaAndValue)accessor.apply(event)));
    }

    private static SchemaAndValue string(String value) {
        return new SchemaAndValue(Schema.STRING_SCHEMA, (Object)value);
    }

    private static SchemaAndValue int32(int value) {
        return new SchemaAndValue(Schema.INT32_SCHEMA, (Object)value);
    }

    private static SchemaAndValue int64(long value) {
        return new SchemaAndValue(Schema.INT64_SCHEMA, (Object)value);
    }

    static {
        LinkedHashMap<String, Function<DocumentEvent, SchemaAndValue>> map = new LinkedHashMap<String, Function<DocumentEvent, SchemaAndValue>>();
        map.put("bucket", event -> CouchbaseHeaderSetter.string(event.bucket()));
        map.put("scope", event -> CouchbaseHeaderSetter.string(event.collectionMetadata().scopeName()));
        map.put("collection", event -> CouchbaseHeaderSetter.string(event.collectionMetadata().collectionName()));
        map.put("key", event -> CouchbaseHeaderSetter.string(event.key()));
        map.put("qualifiedKey", event -> CouchbaseHeaderSetter.string(event.qualifiedKey()));
        map.put("cas", event -> CouchbaseHeaderSetter.int64(event.cas()));
        map.put("partition", event -> CouchbaseHeaderSetter.int32(event.partition()));
        map.put("partitionUuid", event -> CouchbaseHeaderSetter.int64(event.partitionUuid()));
        map.put("seqno", event -> CouchbaseHeaderSetter.int64(event.bySeqno()));
        map.put("rev", event -> CouchbaseHeaderSetter.int64(event.revisionSeqno()));
        map.put("expiry", event -> {
            MutationMetadata md = event.mutationMetadata().orElse(null);
            return md == null || md.expiry() == 0 ? null : CouchbaseHeaderSetter.int64(md.expiry());
        });
        template = Collections.unmodifiableMap(map);
    }
}

