/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.connect.kafka.handler.sink.ConcurrencyHint;
import com.couchbase.connect.kafka.util.N1qlData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsBatchBuilder {
    private final List<Batch> batches = new ArrayList<Batch>();
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsBatchBuilder.class);
    private final long maxBatchSizeInBytes;
    private final int maxRecordsCount;

    public AnalyticsBatchBuilder(long maxBatchSizeInBytes, int maxRecordsCount) {
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
        this.maxRecordsCount = maxRecordsCount;
    }

    public void add(N1qlData data) {
        ConcurrencyHint hint = data.getHint();
        String keyspace = data.getKeyspace();
        N1qlData.OperationType type = data.getType();
        Batch batch = this.getBatch(keyspace, hint, type);
        batch.add(data);
    }

    private Batch getBatch(String keyspace, ConcurrencyHint hint, N1qlData.OperationType type) {
        Batch currentBatch;
        if (!this.batches.isEmpty() && (currentBatch = this.batches.get(this.batches.size() - 1)).isCompatible(keyspace, type, hint)) {
            return currentBatch;
        }
        Batch batch = new Batch(keyspace, type, this.batches.size(), this.maxBatchSizeInBytes, this.maxRecordsCount);
        this.batches.add(batch);
        return batch;
    }

    public List<String> build() {
        LOGGER.info("============Begin Batch Stats=================");
        for (int i = 0; i < this.batches.size(); ++i) {
            Batch batch = this.batches.get(i);
            LOGGER.info("Batch Number: {} sizeOfBatch: {} RecordsInBatch: {} for KeySpace: {}", new Object[]{i + 1, batch.countOfRecordsInCurrentBatch, batch.sizeOfCurrentBatch, batch.keyspace});
        }
        LOGGER.info("============End Batch Stats=================");
        return this.batches.stream().map(Batch::getBlockQuery).collect(Collectors.toList());
    }

    private static class Batch {
        private final N1qlData.OperationType type;
        private final String keyspace;
        private final Set<ConcurrencyHint> hints = new HashSet<ConcurrencyHint>();
        private final StringBuilder batchedData = new StringBuilder();
        private final int batchId;
        private final long maxBatchSizeInBytes;
        private int countOfRecordsInCurrentBatch = 0;
        private final int maxRecordCountLimit;
        private int sizeOfCurrentBatch = 0;

        Batch(String keyspace, N1qlData.OperationType type, int batchId, long maxBatchSizeInBytes, int maxRecordCountLimit) {
            this.type = type;
            this.keyspace = keyspace;
            this.batchId = batchId;
            this.maxBatchSizeInBytes = maxBatchSizeInBytes;
            this.maxRecordCountLimit = maxRecordCountLimit;
        }

        public N1qlData.OperationType getType() {
            return this.type;
        }

        void add(N1qlData data) {
            this.hints.add(data.getHint());
            switch (data.getType()) {
                case UPSERT: {
                    if (this.batchedData.length() != 0) {
                        this.batchedData.append(" , ");
                    }
                    this.batchedData.append(data.getData());
                    this.sizeOfCurrentBatch += data.getData().length();
                    ++this.countOfRecordsInCurrentBatch;
                    break;
                }
                case DELETE: {
                    if (this.batchedData.length() != 0) {
                        this.batchedData.append(" OR ");
                    }
                    this.batchedData.append(data.getData());
                    this.sizeOfCurrentBatch += data.getData().length();
                    ++this.countOfRecordsInCurrentBatch;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No Type " + (Object)((Object)data.getType()) + " Found");
                }
            }
        }

        public int getCountOfRecordsInCurrentBatch() {
            return this.countOfRecordsInCurrentBatch;
        }

        public int getSizeOfCurrentBatch() {
            return this.sizeOfCurrentBatch;
        }

        public boolean isCompatible(String keyspace, N1qlData.OperationType type, ConcurrencyHint hint) {
            return this.keyspace.equals(keyspace) && this.type.equals((Object)type) && !this.hints.contains(hint) && (long)this.sizeOfCurrentBatch < this.maxBatchSizeInBytes && this.countOfRecordsInCurrentBatch < this.maxRecordCountLimit;
        }

        public String getBlockQuery() {
            String queryFromBatchedData;
            switch (this.type) {
                case UPSERT: {
                    queryFromBatchedData = "UPSERT INTO " + this.keyspace + " ([" + this.batchedData + "])";
                    break;
                }
                case DELETE: {
                    queryFromBatchedData = "DELETE FROM " + this.keyspace + " WHERE " + this.batchedData;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No Type " + (Object)((Object)this.type) + " Found");
                }
            }
            return queryFromBatchedData;
        }

        public int getBatchId() {
            return this.batchId;
        }
    }
}

