/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.CouchbaseBucketTopology;
import com.couchbase.client.java.Bucket;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class CouchbaseHelper {
    public static Mono<ClusterTopologyWithBucket> getConfig(Core core, String bucketName) {
        return core.configurationProvider().configs().flatMap(clusterConfig -> Mono.justOrEmpty((Object)clusterConfig.bucketTopology(bucketName))).filter(CouchbaseHelper::hasPartitionInfo).next();
    }

    private static boolean hasPartitionInfo(ClusterTopologyWithBucket topology) {
        CouchbaseBucketTopology bucketTopology = (CouchbaseBucketTopology)topology.bucket();
        return bucketTopology.numberOfPartitions() > 0;
    }

    public static Mono<ClusterTopologyWithBucket> getConfig(Bucket bucket) {
        return CouchbaseHelper.getConfig(bucket.core(), bucket.name());
    }

    public static ClusterTopologyWithBucket getConfig(Bucket bucket, Duration timeout) {
        return (ClusterTopologyWithBucket)CouchbaseHelper.getConfig(bucket).block(timeout);
    }
}

