/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.connect.kafka.handler.sink.SinkDocument;
import com.couchbase.connect.kafka.util.DocumentPathExtractor;
import java.io.IOException;

public interface DocumentIdExtractor {
    public SinkDocument extractDocumentId(byte[] var1, boolean var2) throws IOException, DocumentPathExtractor.DocumentPathNotFoundException;

    public static DocumentIdExtractor from(String documentIdFormat) {
        if (documentIdFormat.isEmpty()) {
            return (json, removeDocumentPath) -> new SinkDocument(null, json);
        }
        DocumentPathExtractor pathExtractor = new DocumentPathExtractor(documentIdFormat);
        return (json, removeDocumentId) -> {
            DocumentPathExtractor.DocumentExtraction extraction = pathExtractor.extractDocumentPath(json, removeDocumentId);
            return new SinkDocument(extraction.getPathValue(), extraction.getData());
        };
    }
}

