/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.client.core.util.CbStrings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class Keyspace {
    private final @Nullable String bucket;
    private final String scope;
    private final String collection;
    private final String formatted;

    public static Keyspace parse(String raw, @Nullable String defaultBucket) {
        try {
            List<String> components = Keyspace.unescapeComponents(raw);
            components.forEach(it -> Keyspace.requireNonBlank(it, "keyspace component"));
            if (components.size() == 2) {
                components.add(0, CbStrings.emptyToNull((String)defaultBucket));
            }
            if (components.size() != 3) {
                throw new IllegalArgumentException("Expected 2 or 3 components, but got " + components.size() + " ; if the bucket name contains a dot, escape it by enclosing it in backticks, like: `my.bucket`.scope.collection");
            }
            return new Keyspace(components.get(0), components.get(1), components.get(2));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse keyspace: " + raw, e);
        }
    }

    public Keyspace(@Nullable String bucket, String scope, String collection) {
        this.bucket = Keyspace.requireNoBackticks(CbStrings.emptyToNull((String)bucket));
        this.scope = Keyspace.requireNoBackticks(Keyspace.requireNonBlank(scope, "scope name"));
        this.collection = Keyspace.requireNoBackticks(Keyspace.requireNonBlank(collection, "collection name"));
        ArrayList<String> components = new ArrayList<String>();
        if (bucket != null) {
            components.add(bucket);
        }
        components.add(scope);
        components.add(collection);
        this.formatted = components.stream().map(it -> "`" + it + "`").collect(Collectors.joining("."));
    }

    private static String requireNonBlank(String s, String name) {
        Objects.requireNonNull(s, name + " is null");
        if (s.trim().isEmpty()) {
            throw new IllegalArgumentException(name + " is blank");
        }
        return s;
    }

    private static @Nullable String requireNoBackticks(@Nullable String s) {
        if (s != null && s.contains("`")) {
            throw new IllegalArgumentException("Keyspace component may not contain a backtick (`), but got: " + s);
        }
        return s;
    }

    public @Nullable String getBucket() {
        return this.bucket;
    }

    public String getScope() {
        return this.scope;
    }

    public String getCollection() {
        return this.collection;
    }

    public String format() {
        return this.formatted;
    }

    public String toString() {
        return "Keyspace{bucket='" + this.bucket + '\'' + ", scope='" + this.scope + '\'' + ", collection='" + this.collection + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Keyspace that = (Keyspace)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.scope, that.scope) && Objects.equals(this.collection, that.collection);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.scope, this.collection);
    }

    private static List<String> unescapeComponents(String raw) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inEscapedRegion = false;
        for (char c : raw.toCharArray()) {
            if (c == '`') {
                inEscapedRegion = !inEscapedRegion;
                continue;
            }
            if (c == '.' && !inEscapedRegion) {
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        if (inEscapedRegion) {
            throw new IllegalArgumentException("Unbalanced backticks for value: " + raw);
        }
        result.add(current.toString());
        return result;
    }
}

