/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util.config;

import com.couchbase.connect.kafka.util.config.DurationParser;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class DurationValidator
implements ConfigDef.Validator {
    public void ensureValid(String name, Object value) {
        try {
            if (value != null && !((String)value).isEmpty()) {
                DurationParser.parseDuration((String)value, TimeUnit.MILLISECONDS);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Failed to parse config property '" + name + "' -- " + e.getMessage());
        }
    }

    public String toString() {
        return "An integer followed by a time unit (ms = milliseconds, s = seconds, m = minutes, h = hours, d = days). For example, to specify 30 minutes: 30m";
    }
}

