/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util.config;

import java.util.Arrays;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class EnumValidator
implements ConfigDef.Validator {
    private final Class<? extends Enum> enumClass;

    public EnumValidator(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
    }

    public void ensureValid(String name, Object value) {
        try {
            Enum.valueOf(this.enumClass, (String)value);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Invalid value '" + value + "' for config key '" + name + "'; must be one of " + Arrays.toString(this.enumClass.getEnumConstants()));
        }
    }

    public String toString() {
        return "One of " + Arrays.toString(this.enumClass.getEnumConstants());
    }
}

