/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util.config;

import com.couchbase.client.core.util.CbCollections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;

public class LookupTable<K, V> {
    private final String propertyName;
    private final V defaultValue;
    private final Map<K, V> map;

    LookupTable(String propertyName, V defaultValue, Map<K, V> map) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.map = CbCollections.mapCopyOf(map);
    }

    public V get(K key) {
        return this.map.getOrDefault(key, this.defaultValue);
    }

    public LookupTable<K, V> withUnderlay(Map<K, V> contexts) {
        HashMap<K, V> newMap = new HashMap<K, V>(contexts);
        newMap.putAll(this.map);
        return new LookupTable<K, V>(this.propertyName, this.defaultValue, newMap);
    }

    public <K2> LookupTable<K2, V> mapKeys(Function<String, K2> keyMapper) {
        Map<Object, Object> newMap = this.map.entrySet().stream().collect(Collectors.toMap(entry -> {
            try {
                return keyMapper.apply((String)entry.getKey());
            }
            catch (RuntimeException e) {
                throw new ConfigException("Invalid configuration " + this.propertyName + "[" + entry.getKey() + "] ; " + e);
            }
        }, Map.Entry::getValue));
        return new LookupTable<Object, Object>(this.propertyName, this.defaultValue, newMap);
    }

    public <V2> LookupTable<K, V2> mapValues(Function<V, V2> valueMapper) {
        Map<Object, Object> newMap = this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> LookupTable.mapOneValue(this.propertyName + "[" + entry.getKey() + "]", entry.getValue(), valueMapper)));
        return new LookupTable<Object, Object>(this.propertyName, LookupTable.mapOneValue(this.propertyName, this.defaultValue, valueMapper), newMap);
    }

    private static <V, R> R mapOneValue(String propertyNameWithContext, V value, Function<V, R> valueMapper) {
        try {
            return valueMapper.apply(value);
        }
        catch (RuntimeException e) {
            throw new ConfigException(propertyNameWithContext, value, e.toString());
        }
    }

    public String toString() {
        return "LookupTable{defaultValue=" + this.defaultValue + ", map=" + this.map + '}';
    }
}

