/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.codec;

import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.TypeRef;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012:\b\u0002\u0010\u0004\u001a4\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007H\u0016\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0012\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u0013\u001a\u0002H\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007H\u0016\u00a2\u0006\u0002\u0010\u0014R@\u0010\u0004\u001a4\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/couchbase/client/kotlin/codec/MoshiJsonSerializer;", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "moshi", "Lcom/squareup/moshi/Moshi;", "customize", "Lkotlin/Function2;", "Lcom/squareup/moshi/JsonAdapter;", "Lcom/couchbase/client/kotlin/codec/TypeRef;", "Lkotlin/ParameterName;", "name", "type", "Lkotlin/ExtensionFunctionType;", "(Lcom/squareup/moshi/Moshi;Lkotlin/jvm/functions/Function2;)V", "deserialize", "T", "json", "", "([BLcom/couchbase/client/kotlin/codec/TypeRef;)Ljava/lang/Object;", "serialize", "value", "(Ljava/lang/Object;Lcom/couchbase/client/kotlin/codec/TypeRef;)[B", "kotlin-client"})
public final class MoshiJsonSerializer
implements JsonSerializer {
    @NotNull
    private final Moshi moshi;
    @NotNull
    private final Function2<JsonAdapter<?>, TypeRef<?>, JsonAdapter<?>> customize;

    public MoshiJsonSerializer(@NotNull Moshi moshi, @NotNull Function2<? super JsonAdapter<?>, ? super TypeRef<?>, ? extends JsonAdapter<?>> customize) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter(customize, (String)"customize");
        this.moshi = moshi;
        this.customize = customize;
    }

    public /* synthetic */ MoshiJsonSerializer(Moshi moshi, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function2 = 1.INSTANCE;
        }
        this(moshi, function2);
    }

    @Override
    @NotNull
    public <T> byte[] serialize(T value2, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        JsonAdapter jsonAdapter = this.moshi.adapter(type.getType());
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter<T>(type.type)");
        JsonAdapter adapter = (JsonAdapter)this.customize.invoke((Object)jsonAdapter, type);
        Buffer buffer = new Buffer();
        adapter.toJson((BufferedSink)buffer, value2);
        return buffer.readByteArray();
    }

    @Override
    public <T> T deserialize(@NotNull byte[] json, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        JsonAdapter jsonAdapter = this.moshi.adapter(type.getType());
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter<T>(type.type)");
        JsonAdapter adapter = (JsonAdapter)this.customize.invoke((Object)jsonAdapter, type);
        Buffer buffer = new Buffer();
        buffer.write(json);
        Object result2 = adapter.fromJson((BufferedSource)buffer);
        if (result2 == null && !type.getNullable()) {
            throw new NullPointerException("Can't deserialize null value into non-nullable type " + type);
        }
        return (T)result2;
    }
}

