/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.kv;

import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.kotlin.kv.ExpiryKt;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0005\u0006\u0007\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H \u00a2\u0006\u0002\b\u0005\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry;", "", "()V", "encode", "Lcom/couchbase/client/core/api/kv/CoreExpiry;", "encode$kotlin_client", "Absolute", "Companion", "None", "Relative", "Unknown", "Lcom/couchbase/client/kotlin/kv/Expiry$None;", "Lcom/couchbase/client/kotlin/kv/Expiry$Unknown;", "Lcom/couchbase/client/kotlin/kv/Expiry$Absolute;", "Lcom/couchbase/client/kotlin/kv/Expiry$Relative;", "kotlin-client"})
public abstract class Expiry {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Expiry() {
    }

    @NotNull
    public abstract CoreExpiry encode$kotlin_client();

    public /* synthetic */ Expiry(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0010\u00a2\u0006\u0002\b\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$None;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "()V", "encode", "Lcom/couchbase/client/core/api/kv/CoreExpiry;", "kotlin.jvm.PlatformType", "encode$kotlin_client", "toString", "", "kotlin-client"})
    public static final class None
    extends Expiry {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
            super(null);
        }

        @Override
        public CoreExpiry encode$kotlin_client() {
            return CoreExpiry.NONE;
        }

        @NotNull
        public String toString() {
            return "None";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Unknown;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "()V", "encode", "", "encode$kotlin_client", "toString", "", "kotlin-client"})
    public static final class Unknown
    extends Expiry {
        @NotNull
        public static final Unknown INSTANCE = new Unknown();

        private Unknown() {
            super(null);
        }

        @NotNull
        public Void encode$kotlin_client() {
            throw new IllegalArgumentException("Expiry.Unknown cannot be used to set a document's expiry. To get a usable Expiry instance, pass `withExpiry = true` when getting the document.");
        }

        @NotNull
        public String toString() {
            return "Unknown (To know expiry, pass `withExpiry = true` when calling `get`)";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\t\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Absolute;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "instant", "Ljava/time/Instant;", "(Ljava/time/Instant;)V", "core", "Lcom/couchbase/client/core/api/kv/CoreExpiry;", "getInstant", "()Ljava/time/Instant;", "encode", "encode$kotlin_client", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-client"})
    public static final class Absolute
    extends Expiry {
        @NotNull
        private final Instant instant;
        @NotNull
        private final CoreExpiry core;

        public Absolute(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            super(null);
            this.instant = instant;
            CoreExpiry coreExpiry = CoreExpiry.of((Instant)this.instant);
            Intrinsics.checkNotNullExpressionValue((Object)coreExpiry, (String)"of(instant)");
            this.core = coreExpiry;
            if (!(this.instant.getEpochSecond() != 0L)) {
                boolean bl = false;
                String string = "Expiry instant " + this.instant + " is too far in the past. Earliest valid expiry instant is " + CoreExpiry.EARLIEST_VALID_EXPIRY_INSTANT;
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Instant getInstant() {
            return this.instant;
        }

        @Override
        @NotNull
        public CoreExpiry encode$kotlin_client() {
            return this.core;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.couchbase.client.kotlin.kv.Expiry.Absolute");
            }
            Absolute cfr_ignored_0 = (Absolute)object2;
            return Intrinsics.areEqual((Object)this.instant, (Object)((Absolute)other).instant);
        }

        public int hashCode() {
            return this.instant.hashCode();
        }

        @NotNull
        public String toString() {
            return "Absolute(instant=" + this.instant + ')';
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0012\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\r\u0010\n\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Relative;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "duration", "Lkotlin/time/Duration;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "core", "Lcom/couchbase/client/core/api/kv/CoreExpiry;", "getDuration-UwyO8pc", "()J", "J", "encode", "encode$kotlin_client", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-client"})
    public static final class Relative
    extends Expiry {
        private final long duration;
        @NotNull
        private final CoreExpiry core;

        private Relative(long duration) {
            super(null);
            long l = this.duration = duration;
            int n = kotlin.time.Duration.getNanosecondsComponent-impl((long)l);
            long l2 = kotlin.time.Duration.getInWholeSeconds-impl((long)l);
            Duration duration2 = Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toJavaDuration-LRDsOJo");
            CoreExpiry coreExpiry = CoreExpiry.of((Duration)duration2);
            Intrinsics.checkNotNullExpressionValue((Object)coreExpiry, (String)"of(duration.toJavaDuration())");
            this.core = coreExpiry;
            long seconds = kotlin.time.Duration.getInWholeSeconds-impl((long)this.duration);
            if (!(seconds > 0L)) {
                boolean $i$a$-require-Expiry$Relative$32 = false;
                String $i$a$-require-Expiry$Relative$32 = ExpiryKt.access$expiryErrorMessage("expiry duration " + kotlin.time.Duration.toString-impl((long)this.duration) + " is less than one second");
                throw new IllegalArgumentException($i$a$-require-Expiry$Relative$32.toString());
            }
            if (!(ExpiryKt.access$currentTimeSeconds() + seconds <= CoreExpiry.LATEST_VALID_EXPIRY_INSTANT.getEpochSecond())) {
                boolean bl = false;
                String string = ExpiryKt.access$expiryErrorMessage("expiry duration " + kotlin.time.Duration.toString-impl((long)this.duration) + " ends too far in the future. Latest valid expiry instant is " + CoreExpiry.LATEST_VALID_EXPIRY_INSTANT);
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final long getDuration-UwyO8pc() {
            return this.duration;
        }

        @Override
        @NotNull
        public CoreExpiry encode$kotlin_client() {
            return this.core;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.couchbase.client.kotlin.kv.Expiry.Relative");
            }
            Relative cfr_ignored_0 = (Relative)object2;
            return kotlin.time.Duration.equals-impl0((long)this.duration, (long)((Relative)other).duration);
        }

        public int hashCode() {
            return kotlin.time.Duration.hashCode-impl((long)this.duration);
        }

        @NotNull
        public String toString() {
            return "Relative(duration=" + kotlin.time.Duration.toString-impl((long)this.duration) + ')';
        }

        public /* synthetic */ Relative(long duration, DefaultConstructorMarker $constructor_marker) {
            this(duration);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001b\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\f"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Companion;", "", "()V", "none", "Lcom/couchbase/client/kotlin/kv/Expiry;", "of", "instant", "Ljava/time/Instant;", "duration", "Lkotlin/time/Duration;", "of-LRDsOJo", "(J)Lcom/couchbase/client/kotlin/kv/Expiry;", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Expiry none() {
            return None.INSTANCE;
        }

        @NotNull
        public final Expiry of-LRDsOJo(long duration) {
            return kotlin.time.Duration.isInfinite-impl((long)duration) ? this.none() : (Expiry)new Relative(duration, null);
        }

        @NotNull
        public final Expiry of(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            return new Absolute(instant);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

