/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jsonskiff;

import com.couchbase.jsonskiff.GrowthStrategy;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class Buffer {
    private byte[] array = new byte[256];
    private int readerIndex = 0;
    private int writerIndex = 0;

    Buffer() {
    }

    public byte[] array() {
        return this.array;
    }

    public int readerIndex() {
        return this.readerIndex;
    }

    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    int writerIndex() {
        return this.writerIndex;
    }

    int maxFastWritableBytes() {
        return this.array.length - this.writerIndex;
    }

    public Buffer skipBytes(int len) {
        int newReaderIndex = this.readerIndex + len;
        if (newReaderIndex < 0 || newReaderIndex > this.writerIndex) {
            throw new IndexOutOfBoundsException("Skipping " + len + " bytes would put the reader index (" + this.readerIndex + ") past the writer index (" + this.writerIndex + ")");
        }
        this.readerIndex = newReaderIndex;
        return this;
    }

    public Buffer writeBytes(byte[] bytes) {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    public Buffer writeBytes(byte[] bytes, int offset, int length) {
        this.ensureWritable(length);
        System.arraycopy(bytes, offset, this.array, this.writerIndex, length);
        this.writerIndex += length;
        return this;
    }

    public Buffer writeBytes(ByteBuffer bytes) {
        int bytesToWrite = bytes.remaining();
        this.ensureWritable(bytesToWrite);
        bytes.get(this.array, this.writerIndex, bytesToWrite);
        this.writerIndex += bytesToWrite;
        return this;
    }

    public Buffer writeBytes(Buffer source, int len) {
        if (len > source.readableBytes()) {
            throw new IndexOutOfBoundsException("Can't read " + len + " bytes from source buffer, because it only has " + source.readableBytes() + " readable bytes.");
        }
        this.writeBytes(source.array, source.readerIndex, len);
        source.readerIndex += len;
        return this;
    }

    public Buffer ensureWritable(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be non-negative, but got: " + length);
        }
        int spaceLeft = this.maxFastWritableBytes();
        if (spaceLeft >= length) {
            return this;
        }
        int additionalRequired = length - spaceLeft;
        this.growToSize(GrowthStrategy.adjustSize(this.array.length + additionalRequired));
        return this;
    }

    private void growToSize(int newSize) {
        if (newSize < this.array.length) {
            throw new UnsupportedOperationException("shrinking is not supported");
        }
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(this.array, 0, newBuffer, 0, this.array.length);
        this.array = newBuffer;
    }

    public Buffer discardSomeReadBytes() {
        if (this.readerIndex == this.writerIndex) {
            return this.clear();
        }
        if (this.readerIndex >= this.array.length / 2) {
            int oldReadableBytes = this.readableBytes();
            System.arraycopy(this.array, this.readerIndex, this.array, 0, oldReadableBytes);
            this.readerIndex = 0;
            this.writerIndex = oldReadableBytes;
        }
        return this;
    }

    public Buffer getBytes(int sourceOffset, byte[] destination) {
        System.arraycopy(this.array, sourceOffset, destination, 0, destination.length);
        return this;
    }

    public boolean isReadable() {
        return this.readableBytes() > 0;
    }

    public Buffer clear() {
        this.readerIndex = 0;
        this.writerIndex = 0;
        return this;
    }

    public String toString() {
        return "Buffer{arrayLength=" + this.array.length + ", readerIndex=" + this.readerIndex + ", writerIndex=" + this.writerIndex + ", readableBytes=" + this.readableBytes() + ", writableBytes=" + this.maxFastWritableBytes() + '}';
    }

    public String toString(Charset charset) {
        return new String(this.array, this.readerIndex, this.readableBytes(), charset);
    }
}

