/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jsonskiff;

import com.couchbase.jsonskiff.Buffer;
import com.couchbase.jsonskiff.CopyingStreamWindow;
import com.couchbase.jsonskiff.MatchedValue;
import com.couchbase.jsonskiff.PathTree;
import com.couchbase.jsonskiff.StreamWindow;
import com.couchbase.jsonskiff.StructureNavigator;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public final class JsonStreamParser
implements Closeable {
    static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonParser parser;
    private final ByteArrayFeeder feeder;
    private final Buffer scratchBuffer = new Buffer();
    private final StreamWindow window = new CopyingStreamWindow();
    private long captureStartOffset = -1L;
    private final StructureNavigator navigator;

    public static Builder builder() {
        return new Builder();
    }

    private JsonStreamParser(PathTree pathTree) {
        this.navigator = new StructureNavigator(this, pathTree);
        try {
            this.parser = jsonFactory.createNonBlockingByteArrayParser();
            this.feeder = (ByteArrayFeeder)this.parser.getNonBlockingInputFeeder();
        }
        catch (IOException shouldNotHappen) {
            throw new UncheckedIOException(shouldNotHappen);
        }
    }

    public void feed(InputStream is) {
        this.feed(is, 8192);
    }

    public void feed(InputStream is, int bufferSizeInBytes) {
        this.scratchBuffer.clear().ensureWritable(bufferSizeInBytes);
        try {
            int bytesRead;
            while ((bytesRead = is.read(this.scratchBuffer.array())) != -1) {
                this.feed(this.scratchBuffer.array(), 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void feed(byte[] array, int offset, int len) {
        try {
            this.feedJackson(array, offset, len);
            this.processTokens();
            this.collectGarbage();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void feed(ByteBuffer input) {
        this.scratchBuffer.clear().writeBytes(input);
        this.feed(this.scratchBuffer.array(), 0, this.scratchBuffer.readableBytes());
    }

    public void endOfInput() {
        try {
            this.feeder.endOfInput();
            this.processTokens();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void feedJackson(byte[] bytes, int offset, int len) throws IOException {
        this.window.add(bytes, offset, len);
        if (offset != 0) {
            this.scratchBuffer.clear();
            this.scratchBuffer.writeBytes(bytes, offset, len);
            bytes = this.scratchBuffer.array();
            offset = 0;
        }
        this.feeder.feedInput(bytes, offset, offset + len);
    }

    private void processTokens() throws IOException {
        JsonToken token;
        while ((token = this.parser.nextToken()) != JsonToken.NOT_AVAILABLE && token != null) {
            this.navigator.accept(token);
        }
        return;
    }

    private void dumpToken(JsonToken token) throws IOException {
        String location = "[" + this.tokenStartOffset() + "," + this.tokenEndOffset() + "]";
        System.out.println(token + " (" + this.parser.getText() + ")  location=" + location);
    }

    private void collectGarbage() {
        if (this.navigator.isCapturing()) {
            this.window.releaseBefore(this.captureStartOffset);
        } else {
            this.window.releaseBefore(this.tokenStartOffset());
        }
    }

    @Nullable String getCurrentName() throws IOException {
        return this.parser.currentName();
    }

    void beginCapture() {
        this.captureStartOffset = this.tokenStartOffset();
    }

    private long tokenStartOffset() {
        return this.parser.currentTokenLocation().getByteOffset() - 1L;
    }

    private long tokenEndOffset() {
        return this.parser.currentLocation().getByteOffset();
    }

    void emitCapturedValue(String jsonPointer, Consumer<MatchedValue> consumer) {
        byte[] capturedValue = this.window.getBytes(this.captureStartOffset, this.tokenEndOffset());
        consumer.accept(new MatchedValue(jsonPointer, capturedValue));
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException shouldNotHappen) {
            throw new UncheckedIOException("Jackson non-blocking JsonParser threw an exception on close, which is totally unexpected.", shouldNotHappen);
        }
    }

    public static final class Builder {
        private final PathTree tree = PathTree.createRoot();
        private volatile boolean frozen;

        Builder() {
        }

        public Builder doOnValue(String jsonPointer, Consumer<MatchedValue> callback) {
            this.checkNotFrozen();
            this.tree.add(jsonPointer, callback);
            return this;
        }

        public JsonStreamParser build() {
            this.frozen = true;
            return new JsonStreamParser(this.tree);
        }

        private void checkNotFrozen() {
            if (this.frozen) {
                throw new IllegalStateException("Can't reconfigure builder after first parser is built.");
            }
        }
    }
}

