/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jsonskiff;

import com.couchbase.jsonskiff.JsonStreamParser;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class MatchedValue {
    private final String jsonPointer;
    private final byte[] json;

    MatchedValue(String jsonPointer, byte[] json) {
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
        this.json = Objects.requireNonNull(json);
    }

    public byte[] bytes() {
        return this.json;
    }

    public boolean isNull() {
        return this.json[0] == 110;
    }

    @Deprecated
    public byte[] readBytes() {
        return this.bytes();
    }

    public String readString() {
        return this.parseOneToken(JsonParser::getValueAsString);
    }

    public double readDouble() {
        return this.parseOneToken(JsonParser::getDoubleValue);
    }

    public long readLong() {
        return this.parseOneToken(JsonParser::getLongValue);
    }

    public boolean readBoolean() {
        return this.parseOneToken(JsonParser::getBooleanValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T parseOneToken(IoFunction<JsonParser, T> reader) {
        try (JsonParser parser = JsonStreamParser.jsonFactory.createParser(this.json);){
            JsonToken token = parser.nextToken();
            if (token == null) {
                throw new UncheckedIOException(new EOFException("Unexpected end of stream for value at " + this.jsonPointer));
            }
            if (token == JsonToken.VALUE_NULL) {
                throw new NullPointerException("Value at " + this.jsonPointer + " is null.");
            }
            JsonParser t = reader.apply(parser);
            return (T)t;
        }
        catch (IOException e) {
            throw new ClassCastException("Value at " + this.jsonPointer + " does not match requested type; " + e);
        }
    }

    public String toString() {
        return "MatchedValue{jsonPointer='" + this.jsonPointer + '\'' + ", json=" + new String(this.json, StandardCharsets.UTF_8) + '}';
    }

    private static interface IoFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

