/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.core.C4Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;
import java.util.EnumSet;

abstract class AbstractConsoleLogger
implements Logger {
    @NonNull
    private EnumSet<LogDomain> logDomains = LogDomain.ALL_DOMAINS;
    @NonNull
    private LogLevel logLevel = LogLevel.WARNING;

    protected AbstractConsoleLogger() {
    }

    @Override
    public void log(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        if (level.compareTo(this.logLevel) < 0 || !this.logDomains.contains((Object)domain)) {
            return;
        }
        this.doLog(level, domain, message);
    }

    @Override
    @NonNull
    public LogLevel getLevel() {
        return this.logLevel;
    }

    public void setLevel(@NonNull LogLevel level) {
        Preconditions.assertNotNull(level, "level");
        if (this.logLevel == level) {
            return;
        }
        this.logLevel = level;
        C4Log.setCallbackLevel(this.logLevel);
    }

    @NonNull
    public EnumSet<LogDomain> getDomains() {
        return this.logDomains;
    }

    public void setDomains(@NonNull EnumSet<LogDomain> domains) {
        this.logDomains = Preconditions.assertNotNull(domains, "domains");
    }

    public void setDomains(LogDomain ... domains) {
        Preconditions.assertNotNull(domains, "domains");
        this.setDomains(EnumSet.copyOf(Arrays.asList(domains)));
    }

    protected abstract void doLog(@NonNull LogLevel var1, @NonNull LogDomain var2, @NonNull String var3);

    @VisibleForTesting
    final void reset() {
        this.logDomains = LogDomain.ALL_DOMAINS;
        this.logLevel = LogLevel.WARNING;
    }
}

