/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.ArrayExpression;
import com.couchbase.lite.Expression;
import com.couchbase.lite.VariableExpression;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;

public final class ArrayExpressionSatisfies {
    @NonNull
    private final ArrayExpression.QuantifiesType type;
    @NonNull
    private final VariableExpression variable;
    @NonNull
    private final Expression inExpression;

    ArrayExpressionSatisfies(@NonNull ArrayExpression.QuantifiesType type, @NonNull VariableExpression variable, @NonNull Expression inExpression) {
        this.type = type;
        this.variable = variable;
        this.inExpression = inExpression;
    }

    @NonNull
    public Expression satisfies(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, "expression");
        return new QuantifiedExpression(this.type, this.variable, this.inExpression, expression);
    }

    private static final class QuantifiedExpression
    extends Expression {
        @NonNull
        private final ArrayExpression.QuantifiesType type;
        @NonNull
        private final VariableExpression variable;
        @NonNull
        private final Expression inExpression;
        @NonNull
        private final Expression satisfiedExpression;

        QuantifiedExpression(@NonNull ArrayExpression.QuantifiesType type, @NonNull VariableExpression variable, @NonNull Expression inExpression, @NonNull Expression satisfiesExpression) {
            this.type = type;
            this.variable = variable;
            this.inExpression = inExpression;
            this.satisfiedExpression = satisfiesExpression;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>(4);
            switch (this.type) {
                case ANY: {
                    json.add("ANY");
                    break;
                }
                case ANY_AND_EVERY: {
                    json.add("ANY AND EVERY");
                    break;
                }
                case EVERY: {
                    json.add("EVERY");
                }
            }
            json.add(this.variable.getName());
            json.add(this.inExpression.asJSON());
            json.add(this.satisfiedExpression.asJSON());
            return json;
        }
    }
}

