/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.core.C4BlobStore;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.support.Log;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public abstract class BaseDatabase {
    @NonNull
    private final Object dbLock = new Object();
    @GuardedBy(value="dbLock")
    @Nullable
    private C4Database c4Database;
    @GuardedBy(value="dbLock")
    @Nullable
    private String path;

    @GuardedBy(value="dbLock")
    protected void setC4DatabaseLocked(@Nullable C4Database c4Database) {
        this.c4Database = c4Database;
        if (c4Database != null) {
            this.path = c4Database.getDbPath();
        }
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    @GuardedBy(value="dbLock")
    @NonNull
    protected C4Database getOpenC4DbLocked() {
        this.mustBeOpen();
        return this.c4Database;
    }

    @GuardedBy(value="dbLock")
    protected boolean isOpen() {
        return this.c4Database != null;
    }

    @GuardedBy(value="dbLock")
    protected void mustBeOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException(Log.lookupStandardMessage("DBClosed"));
        }
    }

    @NonNull
    protected Object getDbLock() {
        return this.dbLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String getDbPath() {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected C4BlobStore getBlobStore() throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().getBlobStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    @NonNull
    @VisibleForTesting
    C4Database getOpenC4Database() {
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
            return this.c4Database;
        }
    }
}

