/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Authenticator;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class BasicAuthenticator
extends Authenticator {
    @NonNull
    private final String username;
    @NonNull
    private final char[] password;

    public BasicAuthenticator(@NonNull String username, @NonNull char[] password) {
        this.username = Preconditions.assertNotNull(username, "username");
        Preconditions.assertNotNull(password, "password");
        this.password = new char[password.length];
        System.arraycopy(password, 0, this.password, 0, this.password.length);
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    @NonNull
    public String getPassword() {
        return new String(this.password);
    }

    @NonNull
    public char[] getPasswordChars() {
        char[] pwd = new char[this.password.length];
        System.arraycopy(this.password, 0, pwd, 0, pwd.length);
        return pwd;
    }

    protected void finalize() throws Throwable {
        try {
            Arrays.fill(this.password, '\u0000');
        }
        finally {
            super.finalize();
        }
    }

    @Override
    void authenticate(@NonNull Map<String, Object> options) {
        HashMap<String, String> auth = new HashMap<String, String>();
        auth.put("type", "Basic");
        auth.put("username", this.username);
        auth.put("password", new String(this.password));
        options.put("auth", auth);
    }
}

