/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.BaseDatabase;
import com.couchbase.lite.Database;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4BlobKey;
import com.couchbase.lite.internal.core.C4BlobReadStream;
import com.couchbase.lite.internal.core.C4BlobStore;
import com.couchbase.lite.internal.core.C4BlobWriteStream;
import com.couchbase.lite.internal.fleece.FLEncodable;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.JSONUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public final class Blob
implements FLEncodable {
    private static final LogDomain DOMAIN = LogDomain.DATABASE;
    public static final String ENCODER_ARG_DB = "BLOB.db";
    public static final String ENCODER_ARG_QUERY_PARAM = "BLOB.queryParam";
    static final String META_PROP_TYPE = "@type";
    static final String TYPE_BLOB = "blob";
    static final String PROP_DIGEST = "digest";
    static final String PROP_LENGTH = "length";
    static final String PROP_CONTENT_TYPE = "content_type";
    static final String PROP_DATA = "data";
    static final String PROP_STUB = "stub";
    static final String PROP_REVPOS = "revpos";
    private static final int MAX_CACHED_CONTENT_LENGTH = 8192;
    private static final String MIME_UNKNOWN = "application/octet-stream";
    @NonNull
    private final String contentType;
    private long blobLength;
    @Nullable
    private byte[] blobContent;
    @Nullable
    private InputStream blobContentStream;
    @Nullable
    private BaseDatabase database;
    @Nullable
    private String blobDigest;

    public static boolean isBlob(@Nullable Map<String, ?> props) {
        Object len;
        if (props == null || !(props.get(PROP_DIGEST) instanceof String)) {
            return false;
        }
        if (!TYPE_BLOB.equals(props.get(META_PROP_TYPE))) {
            return false;
        }
        int nProps = 2;
        if (props.containsKey(PROP_CONTENT_TYPE)) {
            if (!(props.get(PROP_CONTENT_TYPE) instanceof String)) {
                return false;
            }
            ++nProps;
        }
        if ((len = props.get(PROP_LENGTH)) != null) {
            if (!(len instanceof Integer) && !(len instanceof Long)) {
                return false;
            }
            ++nProps;
        }
        return nProps == props.size();
    }

    public Blob(@NonNull String contentType, @NonNull byte[] content) {
        Preconditions.assertNotNull(contentType, "contentType");
        Preconditions.assertNotNull(content, "content");
        this.contentType = contentType;
        this.blobLength = content.length;
        this.blobContent = this.copyBytes(content);
        this.blobContentStream = null;
    }

    public Blob(@NonNull String contentType, @NonNull InputStream stream) {
        Preconditions.assertNotNull(contentType, "contentType");
        this.contentType = contentType;
        this.initStream(stream);
    }

    public Blob(@NonNull String contentType, @NonNull URL fileURL) throws IOException {
        Preconditions.assertNotNull(contentType, "contentType");
        Preconditions.assertNotNull(fileURL, "fileUrl");
        if (!"file".equalsIgnoreCase(fileURL.getProtocol())) {
            throw new IllegalArgumentException(Log.formatStandardMessage("NotFileBasedURL", fileURL));
        }
        this.contentType = contentType;
        this.initStream(fileURL.openStream());
    }

    Blob(@NonNull BaseDatabase database, @NonNull Map<String, Object> properties) {
        String propType;
        this.database = database;
        this.blobDigest = (String)properties.get(PROP_DIGEST);
        Object len = properties.get(PROP_LENGTH);
        if (len instanceof Number) {
            this.blobLength = ((Number)len).longValue();
            Log.w(LogDomain.DATABASE, "Blob length unspecified for blob %s.  Using 0", this.blobDigest);
        }
        if ((propType = (String)properties.get(PROP_CONTENT_TYPE)) == null) {
            propType = MIME_UNKNOWN;
            Log.w(LogDomain.DATABASE, "Blob type unspecified for blob %s.  Using '%s'", this.blobDigest, propType);
        }
        this.contentType = propType;
        Object data = properties.get(PROP_DATA);
        if (data instanceof byte[]) {
            this.blobContent = (byte[])data;
        }
        if (this.blobDigest == null && this.blobContent == null) {
            Log.w(DOMAIN, "Blob read from database has neither digest nor data.");
        }
    }

    @Nullable
    public byte[] getContent() {
        if (this.blobContentStream != null) {
            this.readContentFromInitStream();
        }
        if (this.blobContent != null) {
            return this.copyBytes(this.blobContent);
        }
        if (this.database != null) {
            return this.getContentFromDatabase();
        }
        if (this.blobDigest == null) {
            Log.w(LogDomain.DATABASE, "Blob has no digest");
        }
        return null;
    }

    @Nullable
    public InputStream getContentStream() {
        if (this.blobContentStream != null) {
            return null;
        }
        if (this.blobContent != null) {
            return new ByteArrayInputStream(this.blobContent);
        }
        if (this.database != null) {
            return this.getStreamFromDatabase(this.database);
        }
        if (this.blobDigest == null) {
            Log.w(LogDomain.DATABASE, "Blob has no digest");
        }
        return null;
    }

    @NonNull
    public String getContentType() {
        return this.contentType;
    }

    @NonNull
    public String toJSON() {
        if (this.blobDigest == null) {
            throw new IllegalStateException("A Blob may be encoded as JSON only after it has been saved in a database");
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put(META_PROP_TYPE, TYPE_BLOB);
        json.put(PROP_DIGEST, this.blobDigest);
        json.put(PROP_LENGTH, this.blobLength);
        json.put(PROP_CONTENT_TYPE, this.contentType);
        try {
            return JSONUtils.toJSON(json).toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException("Could not parse Blob JSON", e);
        }
    }

    public long length() {
        return this.blobLength;
    }

    @Nullable
    public String digest() {
        return this.blobDigest;
    }

    @NonNull
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PROP_DIGEST, this.blobDigest);
        props.put(PROP_LENGTH, this.blobLength);
        props.put(PROP_CONTENT_TYPE, this.contentType);
        return props;
    }

    @Override
    public void encodeTo(@NonNull FLEncoder encoder) {
        boolean isQueryParam;
        boolean bl = isQueryParam = encoder.getArg(ENCODER_ARG_QUERY_PARAM) != null;
        if (!isQueryParam) {
            this.installInDatabase(encoder.getArg(ENCODER_ARG_DB));
        }
        encoder.beginDict(4L);
        encoder.writeKey(META_PROP_TYPE);
        encoder.writeValue(TYPE_BLOB);
        encoder.writeKey(PROP_LENGTH);
        encoder.writeValue(this.blobLength);
        encoder.writeKey(PROP_CONTENT_TYPE);
        encoder.writeValue(this.contentType);
        if (this.blobDigest != null) {
            encoder.writeKey(PROP_DIGEST);
            encoder.writeValue(this.blobDigest);
        }
        if (isQueryParam) {
            encoder.writeKey(PROP_DATA);
            encoder.writeValue(this.getContent());
        }
        encoder.endDict();
    }

    @NonNull
    public String toString() {
        return "Blob{" + ClassUtils.objId(this) + ": " + this.blobDigest + "(" + this.contentType + ", " + this.length() + ")}";
    }

    public int hashCode() {
        return Arrays.hashCode(this.getContent());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Blob)) {
            return false;
        }
        Blob m = (Blob)o;
        return this.blobDigest != null && m.blobDigest != null ? this.blobDigest.equals(m.blobDigest) : Arrays.equals(this.getContent(), m.getContent());
    }

    protected void finalize() throws Throwable {
        try {
            InputStream stream = this.blobContentStream;
            if (stream == null) {
                return;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    long updateSize() {
        if (this.database == null) {
            return -1L;
        }
        try (C4BlobStore store = this.database.getBlobStore();){
            C4BlobKey key = new C4BlobKey(this.blobDigest);
            try {
                long storedSize = store.getSize(key);
                if (storedSize >= 0L) {
                    this.blobLength = storedSize;
                }
                long l = storedSize;
                key.close();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    key.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (LiteCoreException liteCoreException) {
            return -1L;
        }
    }

    void installInDatabase(@Nullable Database db) {
        if (this.database != null) {
            if (db != null && !this.database.equals(db)) {
                throw new IllegalStateException(Log.lookupStandardMessage("BlobDifferentDatabase"));
            }
            if (this.blobDigest == null) {
                throw new IllegalStateException("Blob has no digest");
            }
            return;
        }
        this.database = db;
        if (this.blobDigest != null) {
            return;
        }
        try (C4BlobStore store = this.database.getBlobStore();
             C4BlobKey key = this.getBlobKey(store);){
            this.blobDigest = key.toString();
        }
        catch (Exception e) {
            this.database = null;
            this.blobDigest = null;
            throw new IllegalStateException("Failed reading blob content from database", e);
        }
    }

    @Nullable
    private byte[] copyBytes(@Nullable byte[] b) {
        if (b == null) {
            return null;
        }
        int len = b.length;
        byte[] copy = new byte[len];
        System.arraycopy(b, 0, copy, 0, len);
        return copy;
    }

    private void initStream(@NonNull InputStream stream) {
        Preconditions.assertNotNull(stream, "input stream");
        this.blobLength = 0L;
        this.blobContent = null;
        this.blobContentStream = stream;
    }

    private void installInDatabase(@Nullable Object dbArg) {
        if (this.database == null && !(dbArg instanceof Database)) {
            throw new IllegalStateException("No database for Blob save");
        }
        this.installInDatabase((Database)dbArg);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    @Nullable
    private byte[] getContentFromDatabase() {
        byte[] newContent;
        Preconditions.assertNotNull(this.database, "database");
        try (C4BlobStore blobStore = this.database.getBlobStore();
             C4BlobKey key = new C4BlobKey(this.blobDigest);
             FLSliceResult res = blobStore.getContents(key);){
            newContent = res.getBuf();
        }
        catch (LiteCoreException e) {
            String msg = "Failed to read content from database for digest: " + this.blobDigest;
            Log.e(DOMAIN, msg, e);
            throw new IllegalStateException(msg, e);
        }
        if (newContent != null && newContent.length < 8192) {
            this.blobContent = newContent;
        }
        return newContent;
    }

    @NonNull
    private InputStream getStreamFromDatabase(@NonNull BaseDatabase db) {
        C4BlobKey key = new C4BlobKey(this.blobDigest);
        try {
            BlobInputStream blobInputStream = new BlobInputStream(key, db.getBlobStore());
            key.close();
            return blobInputStream;
        }
        catch (Throwable throwable) {
            try {
                try {
                    key.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (LiteCoreException | IllegalArgumentException e) {
                throw new IllegalStateException("Failed opening blobContent stream.", e);
            }
        }
    }

    @NonNull
    private C4BlobKey getBlobKey(@NonNull C4BlobStore store) throws LiteCoreException, IOException {
        if (this.blobContent != null) {
            return store.create(this.blobContent);
        }
        if (this.blobContentStream != null) {
            return this.writeDatabaseFromInitStream(store);
        }
        throw new IllegalStateException(Log.lookupStandardMessage("BlobContentNull"));
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    private void readContentFromInitStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = Preconditions.assertNotNull(this.blobContentStream, "content stream");){
            int n;
            byte[] buff = new byte[8192];
            while ((n = in.read(buff)) >= 0) {
                out.write(buff, 0, n);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed reading blob content stream", e);
        }
        finally {
            this.blobContentStream = null;
        }
        this.blobContent = out.toByteArray();
        this.blobLength = this.blobContent.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    @NonNull
    private C4BlobKey writeDatabaseFromInitStream(@NonNull C4BlobStore store) throws LiteCoreException, IOException {
        C4BlobKey key;
        byte[] buffer;
        if (this.blobContentStream == null) {
            throw new IllegalStateException("Blob stream is null");
        }
        int len = 0;
        try (C4BlobWriteStream blobOut = store.openWriteStream();){
            int n;
            buffer = new byte[8192];
            while ((n = this.blobContentStream.read(buffer)) >= 0) {
                blobOut.write(buffer, n);
                len += n;
            }
            blobOut.install();
            key = blobOut.computeBlobKey();
        }
        finally {
            try {
                this.blobContentStream.close();
            }
            catch (IOException iOException) {}
            this.blobContentStream = null;
        }
        this.blobLength = len;
        if (this.blobContent != null && this.blobContent.length <= 8192) {
            this.blobContent = buffer;
        }
        return key;
    }

    static final class BlobInputStream
    extends InputStream {
        private C4BlobKey key;
        private C4BlobStore store;
        private C4BlobReadStream blobStream;

        BlobInputStream(@NonNull C4BlobKey key, @NonNull C4BlobStore store) throws LiteCoreException {
            Preconditions.assertNotNull(key, "key");
            Preconditions.assertNotNull(store, "store");
            this.key = key;
            this.store = store;
            this.blobStream = store.openReadStream(key);
        }

        @Override
        public int available() throws IOException {
            return super.available();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public synchronized void mark(int readLimit) {
            throw new UnsupportedOperationException("'mark()' not supported for Blob stream");
        }

        @Override
        public synchronized void reset() {
            throw new UnsupportedOperationException("'reset()' not supported for Blob stream");
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.key == null) {
                throw new IOException("Stream is closed");
            }
            try {
                this.blobStream.seek(n);
                return n;
            }
            catch (LiteCoreException e) {
                throw new IOException(e);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.key == null) {
                throw new IOException("Stream is closed");
            }
            try {
                byte[] bytes = this.blobStream.read(1L);
                return bytes.length <= 0 ? -1 : bytes[0] & 0xFF;
            }
            catch (LiteCoreException e) {
                throw new IOException(e);
            }
        }

        @Override
        public int read(@NonNull byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(@NonNull byte[] buf, int off, int len) throws IOException {
            Preconditions.assertNotNull(buf, "buffer");
            if (off < 0) {
                throw new IndexOutOfBoundsException("Read offset < 0: " + off);
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException("Read length < 0: " + len);
            }
            if (off + len > buf.length) {
                throw new IndexOutOfBoundsException("off + len > buf.length (" + off + ", " + len + ", " + buf.length + ")");
            }
            if (len == 0) {
                return 0;
            }
            if (this.key == null) {
                throw new IOException("Stream is closed");
            }
            try {
                int n = this.blobStream.read(buf, off, len);
                return n <= 0 ? -1 : n;
            }
            catch (LiteCoreException e) {
                throw new IOException("Failed reading blob", e);
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.blobStream != null) {
                this.blobStream.close();
                this.blobStream = null;
            }
            if (this.key != null) {
                this.key.close();
                this.key = null;
            }
            if (this.store != null) {
                this.store.close();
                this.store = null;
            }
        }
    }
}

