/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;

public class Collation {
    private final boolean isUnicode;
    @Nullable
    private String locale;
    private boolean ignoreAccents;
    private boolean ignoreCase;

    @NonNull
    public static ASCII ascii() {
        return new ASCII();
    }

    @NonNull
    public static Unicode unicode() {
        return new Unicode();
    }

    protected Collation(boolean isUnicode, @Nullable String locale) {
        this.isUnicode = isUnicode;
        this.locale = locale;
    }

    @NonNull
    protected Collation setLocale(@Nullable String locale) {
        this.locale = locale;
        return this;
    }

    @NonNull
    protected Collation setIgnoreAccents(boolean ignoreAccents) {
        this.ignoreAccents = ignoreAccents;
        return this;
    }

    @NonNull
    protected Collation setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    @NonNull
    public String toString() {
        return "Collation{" + this.locale + ", " + this.isUnicode + ", " + this.ignoreAccents + ", " + this.ignoreCase + '}';
    }

    @NonNull
    Object asJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("UNICODE", this.isUnicode);
        json.put("LOCALE", this.locale);
        json.put("CASE", !this.ignoreCase);
        json.put("DIAC", !this.ignoreAccents);
        return json;
    }

    public static final class Unicode
    extends Collation {
        Unicode() {
            super(true, System.getProperty("user.language"));
        }

        @Override
        @NonNull
        public Unicode setLocale(@Nullable String locale) {
            return (Unicode)super.setLocale(locale);
        }

        @Override
        @NonNull
        public Unicode setIgnoreAccents(boolean ignAccents) {
            return (Unicode)super.setIgnoreAccents(ignAccents);
        }

        @Override
        @NonNull
        public Unicode setIgnoreCase(boolean ignCase) {
            return (Unicode)super.setIgnoreCase(ignCase);
        }
    }

    public static final class ASCII
    extends Collation {
        ASCII() {
            super(false, null);
        }

        @Override
        @NonNull
        public ASCII setIgnoreCase(boolean ignCase) {
            return (ASCII)super.setIgnoreCase(ignCase);
        }
    }
}

