/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Conflict;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.Document;

class DefaultConflictResolver
implements ConflictResolver {
    DefaultConflictResolver() {
    }

    @Override
    @Nullable
    public Document resolve(@NonNull Conflict conflict) {
        long remoteGen;
        Document localDoc = conflict.getLocalDocument();
        Document remoteDoc = conflict.getRemoteDocument();
        if (localDoc == null || remoteDoc == null) {
            return null;
        }
        long localGen = localDoc.generation();
        if (localGen > (remoteGen = remoteDoc.generation())) {
            return localDoc;
        }
        if (localGen < remoteGen) {
            return remoteDoc;
        }
        String localRevId = localDoc.getRevisionID();
        if (localRevId == null) {
            return remoteDoc;
        }
        String remoteRevId = remoteDoc.getRevisionID();
        return remoteRevId == null || localRevId.compareTo(remoteRevId) <= 0 ? remoteDoc : localDoc;
    }
}

